<?php
session_start();

// Database connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$error = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $email = trim($_POST['email']);
    $password = trim($_POST['password']);

    // Fetch id, email, password, and region
$sql = "SELECT id, email, password, region, name FROM users WHERE email = ?";
$stmt = $conn->prepare($sql);
    if (!$stmt) {
        die("Prepare failed: " . $conn->error);
    }
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();

        if (password_verify($password, $user['password'])) {
            // Store user info in session
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['email'] = $user['email'];
            $_SESSION['user_region'] = $user['region']; // 👈 Save region here
           $_SESSION['name'] = $user['name'];  // Add this line to store the name

            // Redirect to home page
            header("Location: ../home.php");
            exit();
        } else {
            $error = "Invalid email or password.";
        }
    } else {
        $error = "Invalid email or password.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Savithri Digital Print Press | Login</title>

<!-- Bootstrap 5 -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<style>
  body {
    font-family: 'Poppins', sans-serif;
    background: #f7f8fa;
    margin: 0;
  }

  /* Header */
  header {
    background-color: #fff;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    padding: 12px 0;
  }
  header img {
    height: 50px;
    margin-right: 10px;
  }
  header .btn {
    font-size: 15px;
    transition: all 0.3s ease;
    box-shadow: 0 4px 10px rgba(47,42,133,0.15);
  }
  header .btn:hover {
    transform: translateY(-2px);
  }

  /* Login Card */
  .login-container {
    min-height: 80vh;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 30px 15px;
  }
  .login-form {
    background: #fff;
    border-radius: 15px;
    padding: 40px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    width: 100%;
    max-width: 420px;
  }
  .login-form h2 {
    color: #2f2a85;
    text-align: center;
    font-weight: 700;
    margin-bottom: 25px;
  }
  .login-form .form-control {
    border-radius: 8px;
    padding: 12px;
  }
  .login-form .btn-primary {
    background-color: #2f2a85;
    border: none;
    border-radius: 8px;
    font-weight: 600;
    padding: 12px;
  }
  .login-form .btn-primary:hover {
    background-color: #251f6d;
  }
  .login-form p {
    text-align: center;
    margin-top: 15px;
    font-size: 14px;
  }
  .error-message {
    color: #d32f2f;
    background: #ffebee;
    padding: 10px;
    border-radius: 6px;
    margin-bottom: 15px;
    text-align: center;
  }
</style>
</head>
<body>

<!-- Header -->
<header>
  <div class="container d-flex align-items-center justify-content-between flex-wrap">
    <!-- Logo + Text -->
    <div class="d-flex align-items-center mb-2 mb-md-0">
      <img src="https://test.kalpavrukshaits.com/savithridigital/images/logo.jpeg" alt="Savithri Logo">
      <div>
        <h4 class="m-0 fw-bold" style="color: #2f2a85;">Savithri</h4>
        <p class="m-0" style="font-size: 13px; line-height: 1;">
          DIGITAL PRINT PRESS (P) LTD<br>
          <span style="font-size: 11px; color: #444;">(a unit of savithri photo house)</span>
        </p>
        <p class="m-0 mt-1 fw-semibold" style="font-style: italic; color: #2f2a85;">
          We Exceed Your Expectations
        </p>
      </div>
    </div>

    <!-- Buttons -->
    <div class="d-flex gap-2">
      <a href="https://test.kalpavrukshaits.com/savithridigital/admin/signin.php" 
         class="btn btn-outline-primary rounded-pill px-4 fw-semibold d-flex align-items-center"
         style="border-color:#2f2a85; color:#2f2a85;">
        <i class="bi bi-box-arrow-in-right me-2"></i> Login
      </a>
      <a href="register.php"
         class="btn rounded-pill px-4 fw-semibold text-white d-flex align-items-center"
         style="background-color:#2f2a85;">
        <i class="bi bi-person-plus-fill me-2"></i> Register
      </a>
    </div>
  </div>
</header>

<!-- Login Form -->
<section class="login-container">
  <div class="login-form">
    <h2>User Login</h2>
    <?php if ($error) { echo "<div class='error-message'>$error</div>"; } ?>

    <form method="POST">
      <div class="mb-3">
        <label class="form-label fw-semibold">Email</label>
        <input type="email" name="email" class="form-control" placeholder="Enter your email" required>
      </div>

      <div class="mb-4">
        <label class="form-label fw-semibold">Password</label>
        <input type="password" name="password" class="form-control" placeholder="Enter your password" required>
      </div>

      <button type="submit" class="btn btn-primary w-100">Login</button>

      <p class="mt-3 text-muted">Don't have an account?
        <a href="register.php" style="color:#2f2a85; text-decoration:none; font-weight:600;">Sign Up</a>
      </p>
    </form>
  </div>
</section>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
