<?php
session_start();
include 'db.php';
header('Content-Type: application/json');

$user_id = $_SESSION['user_id'] ?? 0;
if (!$user_id) {
    echo json_encode(['success' => false, 'error' => 'Not logged in']);
    exit;
}

$data = json_decode(file_get_contents("php://input"), true);
$action = $data['action'] ?? '';
$product_id = $data['product_id'] ?? 0;

if ($action === 'add' && $product_id) {
    $check = $conn->prepare("SELECT quantity FROM user_cart WHERE user_id=? AND product_id=?");
    $check->bind_param("ii", $user_id, $product_id);
    $check->execute();
    $res = $check->get_result();

    if ($res->num_rows > 0) {
        $conn->query("UPDATE user_cart SET quantity = quantity + 1 WHERE user_id=$user_id AND product_id=$product_id");
    } else {
        $conn->query("INSERT INTO user_cart (user_id, product_id, quantity) VALUES ($user_id, $product_id, 1)");
    }

    $countResult = $conn->query("SELECT SUM(quantity) as total FROM user_cart WHERE user_id=$user_id");
    $cart_count = $countResult->fetch_assoc()['total'] ?? 0;

    echo json_encode(['success' => true, 'cart_count' => $cart_count]);
    exit;
}

echo json_encode(['success' => false, 'error' => 'Invalid request']);
?>
