<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>My Website</title>
  <style>
    /* Basic styling */
    body { font-family: Arial, sans-serif; margin: 0; padding: 0; }
    header { background: #333; color: white; padding: 10px 20px; display: flex; justify-content: space-between; align-items: center; }
    header .nav { display: flex; gap: 15px; }
    header .nav a { color: white; text-decoration: none; cursor: pointer; }
    .content { padding: 20px; }
    
    /* Modal (popup) styles */
    .modal-overlay { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.6); justify-content: center; align-items: center; }
    .modal { background: #fff; padding: 20px; border-radius: 5px; width: 300px; }
    .modal h2 { margin-top: 0; }
    .modal input { width: 100%; padding: 8px; margin: 10px 0; box-sizing: border-box; }
    .modal button { padding: 10px 15px; }
    .modal .close-btn { float: right; cursor: pointer; }
  </style>
</head>
<body>
  <header>
    <div class="logo">My Logo</div>
    <nav class="nav">
      <a id="linkHome">Home</a>
      <a id="linkLogin">Login</a>
      <a id="linkRegister">Register</a>
    </nav>
  </header>

  <div class="content">
    <h1>Welcome to My Website</h1>
    <p>This is the homepage with content visible.</p>
    <!-- More sections, images, etc. -->
  </div>

  <!-- Modal for login/register -->
  <div class="modal-overlay" id="modalOverlay">
    <div class="modal" id="modalBox">
      <span class="close-btn" id="modalClose">&times;</span>
      
      <!-- Two forms: you can switch via JS between login and register -->
      <div id="loginForm">
        <h2>Login</h2>
        <input type="text" id="loginUsername" placeholder="Username / Email" />
        <input type="password" id="loginPassword" placeholder="Password" />
        <button type="button" id="btnLogin">Login</button>
        <p>Don't have an account? <a id="showRegister">Register here</a></p>
      </div>
      <div id="registerForm" style="display: none;">
        <h2>Register</h2>
        <input type="text" id="regName" placeholder="Name" />
        <input type="email" id="regEmail" placeholder="Email" />
        <input type="password" id="regPassword" placeholder="Password" />
        <button type="button" id="btnRegister">Register</button>
        <p>Already have an account? <a id="showLogin">Login here</a></p>
      </div>

    </div>
  </div>

  <script>
    // Get elements
    const linkLogin = document.getElementById('linkLogin');
    const linkRegister = document.getElementById('linkRegister');
    const modalOverlay = document.getElementById('modalOverlay');
    const modalClose = document.getElementById('modalClose');
    const loginForm = document.getElementById('loginForm');
    const registerForm = document.getElementById('registerForm');
    const showRegister = document.getElementById('showRegister');
    const showLogin = document.getElementById('showLogin');

    // Open login modal
    linkLogin.addEventListener('click', () => {
      loginForm.style.display = 'block';
      registerForm.style.display = 'none';
      modalOverlay.style.display = 'flex';
    });

    // Open register modal
    linkRegister.addEventListener('click', () => {
      registerForm.style.display = 'block';
      loginForm.style.display = 'none';
      modalOverlay.style.display = 'flex';
    });

    // Close modal
    modalClose.addEventListener('click', () => {
      modalOverlay.style.display = 'none';
    });
    modalOverlay.addEventListener('click', (e) => {
      if (e.target === modalOverlay) {
        modalOverlay.style.display = 'none';
      }
    });

    // Toggle to register from login
    showRegister.addEventListener('click', () => {
      loginForm.style.display = 'none';
      registerForm.style.display = 'block';
    });
    showLogin.addEventListener('click', () => {
      registerForm.style.display = 'none';
      loginForm.style.display = 'block';
    });
  </script>
</body>
</html>
