<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'phpmailer/Exception.php';
require 'phpmailer/PHPMailer.php';
require 'phpmailer/SMTP.php';

// Database connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Ensure token exists in URL
if (!isset($_GET['token']) || empty($_GET['token'])) {
    die("Invalid password reset link.");
}

$token = $_GET['token'];

// Check if token exists in database
$sql = "SELECT id FROM users WHERE reset_token = ?";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}
$stmt->bind_param("s", $token);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die("Invalid or expired token.");
}

$user = $result->fetch_assoc();
$user_id = $user['id'];

$message = "";

// If form is submitted
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];

    // Check password match
    if ($password !== $confirm_password) {
        $message = "<div class='alert alert-danger mt-3'>Passwords do not match.</div>";
    } else {
        // Hash password securely
        $hashed_password = password_hash($password, PASSWORD_BCRYPT);

        // Update password & clear token
        $update_sql = "UPDATE users SET password = ?, reset_token = NULL WHERE id = ?";
        $update_stmt = $conn->prepare($update_sql);
        if (!$update_stmt) {
            die("Prepare failed: " . $conn->error);
        }
        $update_stmt->bind_param("si", $hashed_password, $user_id);
        if ($update_stmt->execute()) {
            $message = "<div class='alert alert-success mt-3'>Password updated successfully. You can now <a href='signin.php' class='text-primary fw-bold'>login</a>.</div>";
        } else {
            $message = "<div class='alert alert-danger mt-3'>Error updating password: " . $conn->error . "</div>";
        }
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Create New Password</title>
     <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      background: linear-gradient(135deg, #74ebd5 0%, #9face6 100%);
      font-family: 'Poppins', sans-serif;
    }
    .glass-form {
      width: 380px;
      padding: 40px;
      border-radius: 20px;
      backdrop-filter: blur(10px);
      background: rgba(255, 255, 255, 0.15);
      box-shadow: 0 8px 32px rgba(0,0,0,0.1);
      color: #fff;
    }
    .glass-form h2 {
      font-weight: 600;
      margin-bottom: 25px;
      text-align: center;
      color: #fff;
    }
    .form-control {
      background: rgba(255, 255, 255, 0.2);
      border: none;
      border-radius: 10px;
      color: #fff;
    }
    .form-control:focus {
      box-shadow: none;
      border: 2px solid #fff;
      background: rgba(255, 255, 255, 0.3);
    }
    .btn-custom {
      width: 100%;
      border-radius: 12px;
      padding: 12px;
      font-weight: 600;
      background: #4CAF50;
      border: none;
      transition: 0.3s;
    }
    .btn-custom:hover {
      background: #43a047;
      transform: translateY(-2px);
    }
    ::placeholder {
      color: #eee;
    }
  </style>
</head>
<body>
    <div class="glass-form">
        <h2>Create Password</h2>
        <form method="POST">
            <div class="mb-3">
                <label class="form-label">New Password</label>
                <input type="password" name="password" placeholder="Enter new password" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Confirm Password</label>
                <input type="password" name="confirm_password" placeholder="Re-enter password" class="form-control" required>
            </div>
            <button class="btn btn-custom">Set Password</button>
        </form>

        <!-- Show success/error message here -->
        <?php if (!empty($message)) echo $message; ?>
    </div>
</body>
</html>
