<?php
$host = 'localhost';
$db = 'bookstore_dashboard';
$user = 'bookstore_dashboard';
$pass = '9(AhSb@uHXMUk0wK';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

// Fetch suppliers
$supplierStmt = $pdo->prepare("SELECT supplier_id, supplier_name, address FROM supplier_master");
$supplierStmt->execute();
$suppliers = $supplierStmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch all book names from product_master
$productStmt = $pdo->prepare("SELECT product_id, product_name FROM product_master");
$productStmt->execute();
$products = $productStmt->fetchAll(PDO::FETCH_ASSOC);

// Generate a new purchase number
$lastPurchaseStmt = $pdo->prepare("SELECT purchase_number FROM purchase_transactions ORDER BY purchase_id DESC LIMIT 1");
$lastPurchaseStmt->execute();
$lastPurchase = $lastPurchaseStmt->fetch(PDO::FETCH_ASSOC);

if ($lastPurchase) {
    $lastNumber = (int)substr($lastPurchase['purchase_number'], 4);
    $newPurchaseNumber = 'PUR-' . str_pad($lastNumber + 1, 3, '0', STR_PAD_LEFT);
} else {
    $newPurchaseNumber = 'PUR-001';
}

// Current date
$currentDate = date('Y-m-d');
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add New Purchase</title>
    <style>
        /* Styling */
        body {
            font-family: Arial, sans-serif;
            background: #f4f4f4;
            padding: 20px;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        h1 {
            text-align: center;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input, select {
            width: 100%;
            padding: 8px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 5px;
        }
        button {
            padding: 10px;
            background: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }
        button:hover {
            background: #0056b3;
        }
        .book-entry {
            display: flex;
            gap: 10px;
            margin-bottom: 10px;
        }
        .book-entry input, .book-entry select {
            flex: 1;
        }
    </style>
    <script>
        function addBookRow() {
            const bookDetails = document.getElementById('book-details');
            const newRow = document.createElement('div');
            newRow.classList.add('book-entry');

            newRow.innerHTML = `
                <select name="book_id[]" required>
                    <option value="">Select Book</option>
                    <?php foreach ($products as $product): ?>
                        <option value="<?php echo $product['product_id']; ?>"><?php echo $product['product_name']; ?></option>
                    <?php endforeach; ?>
                </select>
                <input type="number" name="quantity[]" placeholder="Quantity" min="1" required>
                <input type="number" name="price[]" placeholder="Price" step="0.01" required>
                <input type="number" name="amount[]" placeholder="Amount" step="0.01" readonly required>
                <button type="button" onclick="removeBookRow(this)">Remove</button>
            `;

            bookDetails.appendChild(newRow);
        }

        function removeBookRow(button) {
            button.parentElement.remove();
        }

        function calculateAmount(row) {
            const quantity = row.querySelector('input[name="quantity[]"]').value;
            const price = row.querySelector('input[name="price[]"]').value;
            const amount = row.querySelector('input[name="amount[]"]');
            amount.value = quantity * price || 0;
        }

        document.addEventListener('input', function (event) {
            if (event.target.name === "quantity[]" || event.target.name === "price[]") {
                calculateAmount(event.target.closest('.book-entry'));
            }
        });
    </script>
</head>
<body>
<div class="container">
    <h1>Add New Purchase</h1>
    <form action="save_purchase.php" method="POST">
        <label>Purchase Number</label>
        <input type="text" name="purchase_number" value="<?php echo $newPurchaseNumber; ?>" readonly>

        <label for="supplier_id">Supplier Name</label>
        <select id="supplier_id" name="supplier_id" required>
            <option value="">Select Supplier</option>
            <?php foreach ($suppliers as $supplier): ?>
                <option value="<?php echo $supplier['supplier_id']; ?>"><?php echo $supplier['supplier_name']; ?></option>
            <?php endforeach; ?>
        </select>

        <label for="purchase_date">Bill Date</label>
        <input type="date" id="purchase_date" name="purchase_date" value="<?php echo $currentDate; ?>" required>

        <label for="bill_number">Bill Number</label>
        <input type="text" id="bill_number" name="bill_number" required>

        <label>Book Details</label>
        <div id="book-details">
            <div class="book-entry">
                <select name="book_id[]" required>
                    <option value="">Select Book</option>
                    <?php foreach ($products as $product): ?>
                        <option value="<?php echo $product['product_id']; ?>"><?php echo $product['product_name']; ?></option>
                    <?php endforeach; ?>
                </select>
                <input type="number" name="quantity[]" placeholder="Quantity" min="1" required>
                <input type="number" name="price[]" placeholder="Price" step="0.01" required>
                <input type="number" name="amount[]" placeholder="Amount" readonly required>
            </div>
        </div>
        <button type="button" onclick="addBookRow()">Add Another Book</button>

        <button type="submit">Save Transaction</button>
    </form>
</div>
</body>
</html>
