<?php
// Database Connection
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $transaction_id = $_POST['transaction_id'];
    $return_type = $_POST['return_type'];
    $item_id = $_POST['item_id'];
    $item_type = $_POST['item_type'];
    $quantity = $_POST['quantity'];
    $remarks = $_POST['remarks'];
    $return_date = $_POST['return_date'];

    try {
        $query = "INSERT INTO returns (transaction_id, return_type, item_id, item_type, quantity, remarks, return_date) 
                  VALUES (:transaction_id, :return_type, :item_id, :item_type, :quantity, :remarks, :return_date)";
        $stmt = $pdo->prepare($query);
        $stmt->execute([
            ':transaction_id' => $transaction_id,
            ':return_type' => $return_type,
            ':item_id' => $item_id,
            ':item_type' => $item_type,
            ':quantity' => $quantity,
            ':remarks' => $remarks,
            ':return_date' => $return_date,
        ]);
        $message = "Return record added successfully!";
    } catch (Exception $e) {
        $message = "Error: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Add Returns</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 20px;
        }
        form {
            max-width: 400px;
        }
        form label {
            display: block;
            margin-bottom: 5px;
        }
        form input, form select, form textarea, form button {
            margin-bottom: 15px;
            width: 100%;
            padding: 8px;
            box-sizing: border-box;
        }
        button {
            background-color: #007BFF;
            color: white;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <h1>Add Returns</h1>
    <?php if (!empty($message)) echo "<p>$message</p>"; ?>
    <form action="add_returns.php" method="POST">
        <label for="transaction_id">Transaction ID:</label>
        <input type="number" id="transaction_id" name="transaction_id" required>
        
        <label for="return_type">Return Type:</label>
        <select id="return_type" name="return_type" required>
            <option value="purchase">Purchase</option>
            <option value="sale">Sale</option>
        </select>

        <label for="item_id">Item ID:</label>
        <input type="number" id="item_id" name="item_id" required>

        <label for="item_type">Item Type:</label>
        <select id="item_type" name="item_type" required>
            <option value="book">Book</option>
            <option value="other">Other</option>
        </select>

        <label for="quantity">Quantity:</label>
        <input type="number" id="quantity" name="quantity" required>

        <label for="remarks">Remarks:</label>
        <textarea id="remarks" name="remarks"></textarea>

        <label for="return_date">Return Date:</label>
        <input type="datetime-local" id="return_date" name="return_date" required>

        <button type="submit">Add Return</button>
    </form>
</body>
</html>
