<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Include database connection
include 'db.php';
include 'sidebar.php';

// Fetch branch sales data
$query = "SELECT * FROM branch_sales";
$stmt = $pdo->query($query);
$sales = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Branch Sales</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            font-family: Arial, sans-serif;
        }
        .page-header {
            color: #343a40;
    
    border-radius: 5px;
    margin-bottom: 30px;
        }
       table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            font-size: 18px;
            background: white;
        }
        th, td {
            padding: 12px;
            border: 1px solid #ddd;
            text-align: center;
        }
        th {
            background: #007bff;
                color: black;
    font-size: 15px;
        }
        tr:nth-child(even) {
            background-color:rgb(197, 202, 211);
        }
        tr:hover {
            background-color: #ddd;
        }
        .center-container {
            max-width: 1200px;
            margin: auto;
        }
        .action-btns .btn {
            padding: 5px 10px;
        }
        .btn-add {
            margin-bottom: 20px;
        }
        .search-bar {
            margin-bottom: 20px;
        }
        .add-sale-btn {
            display: inline-block;
            margin-bottom: 20px;
            padding: 10px 15px;
            background: #28a745;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            transition: background 0.3s;
        }
        .add-sale-btn:hover {
            background:rgb(19, 64, 190);
        }
        .button{
            background-color: #007BFF;
            color: white;
            border: none;
            cursor: pointer;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
            margin-left: 10px;
            font-size: 16px;
            font-weight: bold;
            transition: background 0.3s;
        }
        .button:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="page-header">
        <h1 class="text-center">Branch Sales</h1>
    </div>

    <!-- Add New Sale Button -->
    <div class="mb-3">
        
                <a href="add_branchsale.php" class="add-sale-btn"><svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="currentColor" class="bi bi-plus-circle-dotted" viewBox="0 0 16 16">
  <path d="M8 0q-.264 0-.523.017l.064.998a7 7 0 0 1 .918 0l.064-.998A8 8 0 0 0 8 0M6.44.152q-.52.104-1.012.27l.321.948q.43-.147.884-.237L6.44.153zm4.132.271a8 8 0 0 0-1.011-.27l-.194.98q.453.09.884.237zm1.873.925a8 8 0 0 0-.906-.524l-.443.896q.413.205.793.459zM4.46.824q-.471.233-.905.524l.556.83a7 7 0 0 1 .793-.458zM2.725 1.985q-.394.346-.74.74l.752.66q.303-.345.648-.648zm11.29.74a8 8 0 0 0-.74-.74l-.66.752q.346.303.648.648zm1.161 1.735a8 8 0 0 0-.524-.905l-.83.556q.254.38.458.793l.896-.443zM1.348 3.555q-.292.433-.524.906l.896.443q.205-.413.459-.793zM.423 5.428a8 8 0 0 0-.27 1.011l.98.194q.09-.453.237-.884zM15.848 6.44a8 8 0 0 0-.27-1.012l-.948.321q.147.43.237.884zM.017 7.477a8 8 0 0 0 0 1.046l.998-.064a7 7 0 0 1 0-.918zM16 8a8 8 0 0 0-.017-.523l-.998.064a7 7 0 0 1 0 .918l.998.064A8 8 0 0 0 16 8M.152 9.56q.104.52.27 1.012l.948-.321a7 7 0 0 1-.237-.884l-.98.194zm15.425 1.012q.168-.493.27-1.011l-.98-.194q-.09.453-.237.884zM.824 11.54a8 8 0 0 0 .524.905l.83-.556a7 7 0 0 1-.458-.793zm13.828.905q.292-.434.524-.906l-.896-.443q-.205.413-.459.793zm-12.667.83q.346.394.74.74l.66-.752a7 7 0 0 1-.648-.648zm11.29.74q.394-.346.74-.74l-.752-.66q-.302.346-.648.648zm-1.735 1.161q.471-.233.905-.524l-.556-.83a7 7 0 0 1-.793.458zm-7.985-.524q.434.292.906.524l.443-.896a7 7 0 0 1-.793-.459zm1.873.925q.493.168 1.011.27l.194-.98a7 7 0 0 1-.884-.237zm4.132.271a8 8 0 0 0 1.012-.27l-.321-.948a7 7 0 0 1-.884.237l.194.98zm-2.083.135a8 8 0 0 0 1.046 0l-.064-.998a7 7 0 0 1-.918 0zM8.5 4.5a.5.5 0 0 0-1 0v3h-3a.5.5 0 0 0 0 1h3v3a.5.5 0 0 0 1 0v-3h3a.5.5 0 0 0 0-1h-3z"/>
</svg></a>
    </div>

    <!-- Sales Table -->
    
                    <table>
            <thead>
                <th>#</th>
                <th>Branch Code</th>
                <th>Sale Date</th>
                <th>Product</th>
                <th>Quantity</th>
                <th>Total Price</th>
                <th>Sale Type</th>
                <th>Receipt Status</th>
                <th>Branch Name</th>
            </tr>
            </thead>
            <tbody id="salesTableBody">
            <?php
            foreach ($sales as $sale) {
                echo "<tr>
                        <td>{$sale['sale_id']}</td>
                        <td>{$sale['sale_code']}</td>
                        <td>{$sale['sale_date']}</td>
                        <td>{$sale['product_id']}</td>
                        <td>{$sale['quantity']}</td>
                        <td>{$sale['total_price']}</td>
                        <td>{$sale['sale_type']}</td>
                        <td>{$sale['receipt_status']}</td>
                        <td>{$sale['branch_name']}</td>
                    </tr>";
            }
            ?>
            </tbody>
        </table>
    </div>

<script>
    // Search functionality
    document.getElementById('searchInput').addEventListener('keyup', function () {
        const filter = this.value.toLowerCase();
        const rows = document.querySelectorAll('#salesTableBody tr');

        rows.forEach(row => {
            const cells = row.getElementsByTagName('td');
            const saleCode = cells[1].textContent.toLowerCase();
            const branchName = cells[8].textContent.toLowerCase();

            if (saleCode.includes(filter) || branchName.includes(filter)) {
                row.style.display = '';
            } else {
                row.style.display = 'none';
            }
        });
    });
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

