<?php
include 'db.php';
include 'sidebar.php'; // Database connection

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $type_of_books = $_POST['type_of_books'];
    $category_name = $_POST['category_name'];
    $category_id   = $_POST['category_id'];

    try {
        // Insert data into category_master table
        $query = "INSERT INTO category_master (type_of_books, category_id, category_name) VALUES (:type_of_books, :category_id, :category_name)";
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':type_of_books', $type_of_books);
        $stmt->bindParam(':category_name', $category_name);
        $stmt->bindParam(':category_id', $category_id);
        $stmt->execute();

        // Redirect after successful insertion
        header('Location: category_master.php');
        exit();
    } catch (Exception $e) {
        // Handle exceptions
        echo "Error: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Category Master</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
    <style>
      body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }

h2{
    text-align: center;
    color: #343a40;
}
          table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 18px;
            

        }
        th, td {
            border: 1px solid #ddd;
          

        }
        th {
            background: #007bff;
            color: black;
            width: 15%;
            text-align: left;
            padding: 10px;

           
        }
        td {
           
            padding: 8px;
            
           
        }
        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        td:nth-child(4) {
            text-align: right;
        }
        td:nth-child(5) {
            text-align: left;
        }
        td:nth-child(6) {
            text-align: left;
        }
        td:nth-child(7) {
            text-align: left;
        }
        tr:hover {
            background-color: #f1f1f1;
        }


    </style>
    <div class="container mt-5">
        <h2>Category Master</h2>
        

        <!-- Add New Button -->
        <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addCategoryModal"><svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" class="bi bi-plus-circle-fill" viewBox="0 0 16 16">
  <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0M8.5 4.5a.5.5 0 0 0-1 0v3h-3a.5.5 0 0 0 0 1h3v3a.5.5 0 0 0 1 0v-3h3a.5.5 0 0 0 0-1h-3z"/>
</svg></button>
        
        <!-- Category Table -->
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Type of Books</th>
                    <th>Category ID</th>
                    <th>Category Name</th>
                </tr>
            </thead>
            <tbody>
                <?php
                // Fetch all categories from the database
                $query = "SELECT * FROM category_master";
                $categories = $pdo->query($query)->fetchAll();
                if (!empty($categories)) {
                    foreach ($categories as $index => $category) {
                        echo "<tr>
                                <td>" . ($index + 1) . "</td>
                                <td>" . htmlspecialchars($category['type_of_books']) . "</td>
                                <td>" . htmlspecialchars($category['category_id']) . "</td>
                                <td>" . htmlspecialchars($category['category_name']) . "</td>
                            </tr>";
                    }
                } else {
                    echo "<tr><td colspan='4' class='text-center'>No Categories Found</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>

    <!-- Add Category Modal -->
    <div class="modal fade" id="addCategoryModal" tabindex="-1" aria-labelledby="addCategoryModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="category_master.php" method="POST">
                    <div class="modal-header">
                        <h5 class="modal-title" id="addCategoryModalLabel">Add New Category</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        
                        <div class="mb-3">
                            <label for="category_id" class="form-label">Category ID</label>
                            <input type="text" class="form-control" id="category_id" name="category_id" required>
                        </div>
                        <div class="modal-body">
    <div class="mb-3">
        <label for="type_of_books" class="form-label">Type</label>
        <select class="form-select" id="type_of_books" name="type_of_books" required onchange="updateCategoryNameOptions()">
            <option value="">Select Type</option>
            <option value="books">Books</option>
            <option value="other">Other</option>
        </select>
    </div>
    
    <div class="mb-3">
        <label for="category_name" class="form-label">Category Name</label>
        <select class="form-select" id="category_name" name="category_name" required>
            <option value="">Select Category Name</option>
        </select>
    </div>
</div>

                        
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Save</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    function updateCategoryNameOptions() {
        const typeOfBooks = document.getElementById("type_of_books").value;
        const categoryNameDropdown = document.getElementById("category_name");

        categoryNameDropdown.innerHTML = ""; // Clear existing options

        if (typeOfBooks === "books") {
            const booksCategories = ["Books_English", "Books_Hindi", "Books_Tamil"];
            booksCategories.forEach(category => {
                const option = document.createElement("option");
                option.value = category.toLowerCase();
                option.textContent = category;
                categoryNameDropdown.appendChild(option);
            });
        } else if (typeOfBooks === "other") {
            const otherCategories = ["Others_Caps", "Others_Stick"];
            otherCategories.forEach(category => {
                const option = document.createElement("option");
                option.value = category.toLowerCase();
                option.textContent = category;
                categoryNameDropdown.appendChild(option);
            });
        }

        // Add placeholder if no valid type selected
        if (categoryNameDropdown.options.length === 0) {
            const placeholderOption = document.createElement("option");
            placeholderOption.value = "";
            placeholderOption.textContent = "Select Category Name";
            categoryNameDropdown.appendChild(placeholderOption);
        }
    }
</script>

</body>
</html>
