<?php
if (isset($_GET['id'])) {
    $supplier_id = $_GET['id'];

    // SQL query to fetch supplier details
    $stmt = $pdo->prepare("SELECT * FROM supplier_master WHERE supplier_id = ?");
    $stmt->execute([$supplier_id]);
    $supplier = $stmt->fetch();

    if ($supplier) {
        // Display the form with pre-filled data
        ?>
        <h2>Edit Supplier</h2>
        <form method="POST" action="edit_supplier.php?id=<?php echo $supplier['supplier_id']; ?>">
            <label>Supplier Name:</label>
            <input type="text" name="supplier_name" value="<?php echo $supplier['supplier_name']; ?>" required><br>

            <label>Address:</label>
            <textarea name="address" required><?php echo $supplier['address']; ?></textarea><br>

            <label>City:</label>
            <input type="text" name="city" value="<?php echo $supplier['city']; ?>" required><br>

            <label>Pincode:</label>
            <input type="text" name="pincode" value="<?php echo $supplier['pincode']; ?>" required><br>

            <label>Email ID:</label>
            <input type="email" name="email_id" value="<?php echo $supplier['email_id']; ?>" required><br>

            <label>Contact Person Name:</label>
            <input type="text" name="contact_person_name" value="<?php echo $supplier['contact_person_name']; ?>" required><br>

            <label>Mobile Number:</label>
            <input type="text" name="mobile_number" value="<?php echo $supplier['mobile_number']; ?>" required><br>

            <button type="submit" name="update">Update Supplier</button>
        </form>

        <?php
    } else {
        echo "Supplier not found!";
    }

} 

// Handle form submission to update supplier
if (isset($_POST['update'])) {
    $supplier_name = $_POST['supplier_name'];
    $address = $_POST['address'];
    $city = $_POST['city'];
    $pincode = $_POST['pincode'];
    $email_id = $_POST['email_id'];
    $contact_person_name = $_POST['contact_person_name'];
    $mobile_number = $_POST['mobile_number'];

    // Update the supplier's information
    $sql = "UPDATE supplier_master SET 
            supplier_name = ?, address = ?, city = ?, pincode = ?, 
            email_id = ?, contact_person_name = ?, mobile_number = ? 
            WHERE supplier_id = ?";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$supplier_name, $address, $city, $pincode, $email_id, $contact_person_name, $mobile_number, $_GET['id']]);

    echo "Supplier Updated Successfully!";
}
?>
