<?php
require 'db.php';

if (isset($_POST['bill_number'])) {
    $bill_number = $_POST['bill_number'];

    // Get purchase_id based on bill_number
    $purchaseQuery = "SELECT purchase_id FROM purchase_transactions WHERE bill_number = :bill_number";
    $stmt = $pdo->prepare($purchaseQuery);
    $stmt->execute(['bill_number' => $bill_number]);
    $purchase = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($purchase) {
        $purchase_id = $purchase['purchase_id'];

        // Fetch books from purchase_items and join with product_master for book name
        $bookQuery = "SELECT pi.item_id, pi.quantity, pi.price, pm.product_name 
                      FROM purchase_items pi
                      JOIN product_master pm ON pi.product_id = pm.product_id
                      WHERE pi.purchase_id = :purchase_id";
        $stmt = $pdo->prepare($bookQuery);
        $stmt->execute(['purchase_id' => $purchase_id]);
        $books = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($books) {
            foreach ($books as $book) {
                echo "<tr>
                        <td>{$book['product_name']}</td>
                        <td>{$book['quantity']}</td>
                        <td>{$book['price']}</td>
                        <td><input type='number' name='return_quantity[{$book['item_id']}]' class='form-control' min='0' max='{$book['quantity']}'></td>
                      </tr>";
            }
        } else {
            echo "<tr><td colspan='4' class='text-center'>No books found for this bill number.</td></tr>";
        }
    } else {
        echo "<tr><td colspan='4' class='text-center'>Invalid Bill Number.</td></tr>";
    }
} else {
    echo "<tr><td colspan='4' class='text-center'>Bill Number not provided.</td></tr>";
}
?>
