<?php
require 'db.php';

if (isset($_POST['sale_code'])) {
    $sale_code = $_POST['sale_code'];

    // Fetch book details for the selected sale_code
    $query = "SELECT bs.product_id, pm.product_name, bs.quantity, bs.total_price 
              FROM branch_sales bs
              JOIN product_master pm ON bs.product_id = pm.product_id
              WHERE bs.sale_code = :sale_code";
    
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':sale_code', $sale_code);
    $stmt->execute();
    $books = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($books) {
        foreach ($books as $book) {
            echo "<tr>
                    <td class='book-name'>{$book['product_name']}</td>
                    <td class='total-amount'>{$book['total_price']}</td>
                    <td><input type='number' class='form-control handover-amount' min='0' max='{$book['total_price']}' value='0'></td>
                    <td class='balance-amount'>{$book['total_price']}</td>
                  </tr>";
        }
    } else {
        echo "<tr><td colspan='4' class='text-center'>No books found for this sale code.</td></tr>";
    }
}
?>
