<?php
require 'db.php';

if (isset($_POST['sale_code'])) {
    $sale_code = $_POST['sale_code'];

    $query = "SELECT b.product_id, b.total_price, s.total_amount, s.amount_paid, (s.total_amount - s.amount_paid) AS balance
              FROM branch_sales s
              JOIN product_master b ON s.product_id = b.product_id
              WHERE s.sale_code = :sale_code";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':sale_code', $sale_code);
    $stmt->execute();
    $salesDetails = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!empty($salesDetails)) {
        echo "<table class='table table-bordered'>
                <tr><th>Book Name</th><th>Price</th><th>Total Amount</th><th>Paid Amount</th><th>Balance</th></tr>";
        
        foreach ($salesDetails as $detail) {
            echo "<tr>
                    <td>{$detail['product_name']}</td>
                    <td>{$detail['mrp']}</td>
                    <td>{$detail['total_amount']}</td>
                    <td>{$detail['amount_paid']}</td>
                    <td>{$detail['balance']}</td>
                  </tr>";
        }

        echo "</table>
              <label>Enter Handover Amount:</label>
              <input type='number' id='handover_amount' class='form-control'>
              <button id='update_status' class='btn btn-primary mt-2'>Update Status</button>";
    } else {
        echo "<p>No sales found.</p>";
    }
}
?>
