<?php
require 'db.php';

if (isset($_POST['invoice_number'])) {
    $invoice_number = $_POST['invoice_number'];

    // Fetch books sold in the selected invoice_number
    $query = "SELECT s.product_id, p.product_name, s.quantity, p.mrp AS price
              FROM sales_transactions s
              JOIN product_master p ON s.product_id = p.product_id
              WHERE s.invoice_number = ?";
    
    $stmt = $pdo->prepare($query);
    $stmt->execute([$invoice_number]);
    $books = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($books) {
        foreach ($books as $book) {
            echo "<tr>
                    <td>{$book['product_name']}</td>
                    <td>{$book['quantity']}</td>
                    <td>{$book['price']}</td>
                    <td>
                        <input type='hidden' name='product_id[]' value='{$book['product_id']}'>
                        <input type='number' name='return_quantity[]' class='form-control return_quantity' min='0' placeholder='Enter return quantity (optional)'>
                    </td>
                  </tr>";
        }
    } else {
        echo "<tr><td colspan='4' class='text-center text-danger'>No books found for this invoice.</td></tr>";
    }
} else {
    echo "<tr><td colspan='4' class='text-center text-danger'>Error: Invoice number not received.</td></tr>";
}
?>
