<?php
session_start();
require 'db.php'; // Database connection

// Redirect if not logged in
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: admin_login.php");
    exit();
}

// Fetch data dynamically
try {
    // Total Books Count
    $bookCountQuery = $pdo->query("SELECT COUNT(*) AS total_books FROM product_master");
    $totalBooks = $bookCountQuery->fetch(PDO::FETCH_ASSOC)['total_books'];

    // Total Stock Count
    $stockQuery = $pdo->query("SELECT SUM(stock) AS total_stock FROM product_master");
    $totalStock = $stockQuery->fetch(PDO::FETCH_ASSOC)['total_stock'];

    // Total Purchases
    $purchaseQuery = $pdo->query("SELECT SUM(total_amount) AS total_purchases FROM purchase_transactions");
    $totalPurchases = $purchaseQuery->fetch(PDO::FETCH_ASSOC)['total_purchases'];

    // Total Sales
    $salesQuery = $pdo->query("SELECT SUM(total_amount) AS total_sales FROM sales_transactions");
    $totalSales = $salesQuery->fetch(PDO::FETCH_ASSOC)['total_sales'];

    // Categories
    $categoriesQuery = $pdo->query("SELECT category_name FROM category_master");
    $categories = $categoriesQuery->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Database error: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-4">
        <h2 class="mb-4">Welcome to the Dashboard</h2>
        <div class="row">
            <div class="col-md-3">
                <div class="card text-white bg-primary mb-3">
                    <div class="card-body">
                        <h5 class="card-title">Total Books</h5>
                        <p class="card-text"> <?= $totalBooks ?> </p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-success mb-3">
                    <div class="card-body">
                        <h5 class="card-title">Total Stock</h5>
                        <p class="card-text"> <?= $totalStock ?> </p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-warning mb-3">
                    <div class="card-body">
                        <h5 class="card-title">Total Purchases</h5>
                        <p class="card-text"> ₹<?= number_format($totalPurchases, 2) ?> </p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-danger mb-3">
                    <div class="card-body">
                        <h5 class="card-title">Total Sales</h5>
                        <p class="card-text"> ₹<?= number_format($totalSales, 2) ?> </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="card mb-3">
                    <div class="card-header">Categories</div>
                    <ul class="list-group list-group-flush">
                        <?php foreach ($categories as $category) { ?>
                            <li class="list-group-item"> <?= $category['category_name'] ?> </li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
