<div class="container mt-5">
    <h2>Purchase Books</h2>
    <form action="purchase_books.php" method="POST">
        <div class="mb-3">
            <label for="supplier_id" class="form-label">Supplier ID</label>
            <input type="number" class="form-control" id="supplier_id" name="supplier_id" required>
        </div>
        <div class="mb-3">
            <label for="product_id" class="form-label">Product ID</label>
            <input type="number" class="form-control" id="product_id" name="product_id" required>
        </div>
        <div class="mb-3">
            <label for="quantity" class="form-label">Quantity</label>
            <input type="number" class="form-control" id="quantity" name="quantity" required>
        </div>
        <div class="mb-3">
            <label for="total_price" class="form-label">Total Price</label>
            <input type="number" class="form-control" step="0.01" id="total_price" name="total_price" required>
        </div>
        <div class="mb-3">
            <label for="purchase_date" class="form-label">Purchase Date</label>
            <input type="date" class="form-control" id="purchase_date" name="purchase_date" required>
        </div>
        <button type="submit" class="btn btn-primary">Submit</button>
    </form>
</div>
<?php
include 'db.php'; // Include the database connection

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $supplier_id = $_POST['supplier_id'];
    $product_id = $_POST['product_id'];
    $quantity = $_POST['quantity'];
    $total_price = $_POST['total_price'];
    $purchase_date = $_POST['purchase_date'];

    try {
        $query = "INSERT INTO purchase_books (supplier_id, product_id, quantity, total_price, purchase_date)
                  VALUES (:supplier_id, :product_id, :quantity, :total_price, :purchase_date)";
        $stmt = $pdo->prepare($query);
        $stmt->bindParam(':supplier_id', $supplier_id);
        $stmt->bindParam(':product_id', $product_id);
        $stmt->bindParam(':quantity', $quantity);
        $stmt->bindParam(':total_price', $total_price);
        $stmt->bindParam(':purchase_date', $purchase_date);
        $stmt->execute();

        header('Location: purchase_books.php');
        exit();
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}
?>
