<?php
include 'sidebar.php';

// Database connection
$host = 'localhost';
$db = 'bookstore_dashboard';
$user = 'bookstore_dashboard';
$pass = '9(AhSb@uHXMUk0wK';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Fetch dates from the request
    $fromDate = $_GET['from_date'] ?? '';
    $toDate = $_GET['to_date'] ?? '';

    // Format the dates if they are not empty
    if (!empty($fromDate)) {
        $fromDate = date('Y-m-d', strtotime($fromDate));
    }
    if (!empty($toDate)) {
        $toDate = date('Y-m-d', strtotime($toDate));
    }

    // Base query
    $query = "
        SELECT 
            pt.purchase_number,
            pt.purchase_date,
            pt.bill_number,
            pt.total_cost,
            sm.supplier_name,
            sm.address AS supplier_address,
            sm.city,
            sm.pincode,
            GROUP_CONCAT(CONCAT(pm.product_name, ' (', pi.quantity, ')')) AS product_details
        FROM 
            purchase_transactions pt
        JOIN 
            supplier_master sm ON pt.supplier_id = sm.supplier_id
        LEFT JOIN 
            purchase_items pi ON pt.purchase_id = pi.purchase_id
        LEFT JOIN 
            product_master pm ON pi.product_id = pm.product_id
    ";

    // Add conditions if dates are provided
    $conditions = [];
    if (!empty($fromDate) && !empty($toDate)) {
        $conditions[] = "pt.purchase_date BETWEEN :fromDate AND :toDate";
    } elseif (!empty($fromDate)) {
        $conditions[] = "pt.purchase_date >= :fromDate";
    } elseif (!empty($toDate)) {
        $conditions[] = "pt.purchase_date <= :toDate";
    }

    if ($conditions) {
        $query .= " WHERE " . implode(' AND ', $conditions);
    }
    $query .= " GROUP BY pt.purchase_id ORDER BY pt.purchase_date DESC";

    // Prepare the statement
    $stmt = $pdo->prepare($query);

    // Bind parameters if dates are provided
    if (!empty($fromDate)) {
        $stmt->bindParam(':fromDate', $fromDate);
    }
    if (!empty($toDate)) {
        $stmt->bindParam(':toDate', $toDate);
    }

    $stmt->execute();
    $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Purchase Report</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f9;
        }

        h1 {
            text-align: center;
            color: #333;
            padding: 20px 0;
            font-size: 2.5em;
        }

         .container {
        width: 90%;
        max-width: 1200px;
        margin: auto;
        
        padding: 20px;
        border-radius: 8px;
        
    }

    .search-form {
        display: flex;
        justify-content: space-between;
        align-items: flex-end;
        margin-bottom: 20px;
        
        padding: 15px;
        border-radius: 8px;
        
    }

    .form-group {
        display: flex;
        flex-direction: column;
        width: 40%; /* Reduced width */
    }

    .form-group label {
        font-size: 14px;
        margin-bottom: 5px;
        color: #555;
    }

    .form-group input {
        font-size: 14px;
        padding: 6px 10px;
        border: 1px solid #ddd;
        border-radius: 5px;
        background: #fafafa;
    }

    .form-group input:focus {
        border-color: #007bff;
        outline: none;
        background: #fff;
    }

    .button-group {
        display: flex;
        align-items: center;
    }

    .btn {
        padding: 8px 16px;
        font-size: 14px;
        margin-right: 8px;
        background-color: #007bff;
        color: white;
        border: none;
        border-radius: 5px;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    .btn:hover {
        background-color: #0056b3;
    }

    .clear-btn {
        padding: 8px 16px;
        font-size: 14px;
        background: #f1f1f1;
        color: #333;
        border: 1px solid #ddd;
        border-radius: 5px;
        cursor: pointer;
    }

    .clear-btn:hover {
        background-color: #e1e1e1;
    }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        th, td {
            padding: 12px 15px;
            border: 1px solid #ddd;
            text-align: left;
        }

        th {
            background-color: #007bff;
            color: black;
    font-size: 15px;
}

        tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        tr:hover {
            background-color: #f1f1f1;
        }

        .no-data {
            text-align: center;
            font-size: 1.2em;
            color: #777;
            padding: 20px;
        }
    </style>
</head>
<body>

<div class="container">
    <h1>Purchase Report</h1>

    <!-- Search Form -->
    <form method="GET" action="purchase_report.php" class="search-form">
        <div class="form-group">
            <label for="from_date">From Date</label>
            <input type="date" id="from_date" name="from_date" value="<?= htmlspecialchars($fromDate) ?>" required>
        </div>
        <div class="form-group">
            <label for="to_date">To Date</label>
            <input type="date" id="to_date" name="to_date" value="<?= htmlspecialchars($toDate) ?>" required>
        </div>
        <div class="button-group">
            <button type="submit" class="btn">Search</button>
            <a href="purchase_report.php" class="clear-btn">Clear</a>
        </div>
    </form>
    <!-- Purchase Report Table -->
    <?php if (count($transactions) > 0): ?>
        <table>
            <thead>
                <tr>
                    <th>Purchase Number</th>
                    <th>Date</th>
                    <th>Bill Number</th>
                    <th>Supplier</th>
                    <th>Supplier Address</th>
                    <th>City</th>
                    <th>Total Cost</th>
                    <th>Books</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transactions as $transaction): ?>
                    <tr>
                        <td><?= htmlspecialchars($transaction['purchase_number']) ?></td>
                        <td><?= htmlspecialchars($transaction['purchase_date']) ?></td>
                        <td><?= htmlspecialchars($transaction['bill_number']) ?></td>
                        <td><?= htmlspecialchars($transaction['supplier_name']) ?></td>
                        <td><?= htmlspecialchars($transaction['supplier_address']) ?></td>
                        <td><?= htmlspecialchars($transaction['city']) ?></td>
                        <td>₹<?= number_format((float)$transaction['total_cost'], 2) ?></td>
                        <td><?= htmlspecialchars($transaction['product_details']) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <div class="no-data">No transactions found for the selected date range.</div>
    <?php endif; ?>
</div>

</body>
</html>
