<?php
require 'db.php';
include 'sidebar.php';

// Fetching receipt details
$query = "SELECT receipt_id, sale_code, product_name, total_amount, handover_amount, balance_amount, receipt_status 
          FROM branch_sales_receipt";
$stmt = $pdo->prepare($query);
$stmt->execute();
$receipts = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Receipt Status</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
          body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        th {
            background-color:rgb(28, 139, 230);
        }
        tr:hover {
            background-color: #f1f1f1;
        }
        form {
            margin-top: 20px;
        }
        h1 {
            text-align: center;
            color: #333;
        }
    </style>
</head>
<body>

<div class="container mt-4">
    <h2 class="text-center">Receipt Status</h2><br><br>
    <table>
        <thead>
            <tr>
                <th>Branch Code</th>
                <th>Book Name</th>
                <th>Total Amount</th>
                <th>Handover Amount</th>
                <th>Balance Amount</th>
                <th>Status</th>
                <th>Enter Amount</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($receipts as $receipt): ?>
                <tr>
                    <td><?= htmlspecialchars($receipt['sale_code']) ?></td>
                    <td><?= htmlspecialchars($receipt['product_name']) ?></td>
                    <td class="total"><?= number_format($receipt['total_amount'], 2) ?></td>
                    <td class="handover"><?= number_format($receipt['handover_amount'], 2) ?></td>
                    <td class="balance"><?= number_format($receipt['balance_amount'], 2) ?></td>
                    <td id="status-<?= $receipt['receipt_id'] ?>"><?= htmlspecialchars($receipt['receipt_status']) ?></td>
                    <td>
                        <input type="number" class="form-control enter-amount" 
                               data-receipt-id="<?= $receipt['receipt_id'] ?>"
                               placeholder="Enter Amount">
                    </td>
                    <td>
                        <button class="btn btn-success mark-paid"
                                data-receipt-id="<?= $receipt['receipt_id'] ?>"
                                data-total="<?= $receipt['total_amount'] ?>"
                                data-handover="<?= $receipt['handover_amount'] ?>">
                            Select
                        </button>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
$(document).ready(function () {
    $(".mark-paid").click(function () {
        let receiptId = $(this).data("receipt-id");
        let totalAmount = parseFloat($(this).data("total"));
        let handoverAmount = parseFloat($(this).data("handover"));
        let enteredAmount = parseFloat($("input[data-receipt-id='" + receiptId + "']").val());

        if (isNaN(enteredAmount) || enteredAmount <= 0) {
            alert("Please enter a valid amount.");
            return;
        }

        let newHandoverAmount = handoverAmount + enteredAmount;
        let newBalance = totalAmount - newHandoverAmount;

        if (newHandoverAmount >= totalAmount) {
            $.post("update_receipt_status.php", { 
                receipt_id: receiptId, 
                handover_amount: newHandoverAmount, 
                balance_amount: newBalance 
            }, function (response) {
                if (response === "success") {
                    $("#status-" + receiptId).text("Paid");
                    location.reload();
                } else {
                    alert("Error updating receipt status.");
                }
            });
        } else {
            alert("Total amount and handover amount must be equal to mark as Paid.");
        }
    });
});
</script>

</body>
</html>
