<?php
session_start();
require 'db.php';
include 'sidebar.php';


// Fetch suppliers
$supplierQuery = "SELECT DISTINCT s.supplier_id, s.supplier_name 
                  FROM supplier_master s 
                  JOIN purchase_transactions p ON s.supplier_id = p.supplier_id";
$supplierStmt = $pdo->prepare($supplierQuery);
$supplierStmt->execute();
$suppliers = $supplierStmt->fetchAll(PDO::FETCH_ASSOC);


$returnQuery = "SELECT pr.return_id, pr.supplier_id, s.supplier_name, pt.bill_number, 
                       pr.product_id, pm.product_name, pr.return_quantity, pr.return_date 
                FROM purchase_returns pr
                JOIN product_master pm ON pr.product_id = pm.product_id
                JOIN supplier_master s ON pr.supplier_id = s.supplier_id
                JOIN purchase_transactions pt ON pr.purchase_number = pt.purchase_number
                ORDER BY pr.return_date DESC";

$returnStmt = $pdo->prepare($returnQuery);
$returnStmt->execute();
$returns = $returnStmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Purchase Returns</title>
   <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
          body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        th {
            background-color:rgb(28, 139, 230);
        }
        tr:hover {
            background-color: #f1f1f1;
        }
        form {
            margin-top: 20px;
        }
        h1 {
            text-align: center;
            color: #333;
        }
    </style>
</head>
<body>
    
<div class="container mt-4">
    <h2 class="text-center">Purchase Returns</h2>
    
    
    <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#returnModal"><svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" class="bi bi-plus-circle-fill" viewBox="0 0 16 16">
  <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0M8.5 4.5a.5.5 0 0 0-1 0v3h-3a.5.5 0 0 0 0 1h3v3a.5.5 0 0 0 1 0v-3h3a.5.5 0 0 0 0-1h-3z"/>
</svg></button>
    <div class="container mt-4">
    <h3>Return Details</h3>
    <table>
                                <thead>
            <tr>
                <th>#</th>
                <th>Supplier Name</th>
                <th>Bill Number</th>
                <th>Book Name</th>
                <th>Return Quantity</th>
                <th>Return Date</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($returns)) : ?>
                <?php foreach ($returns as $index => $row) : ?>
                    <tr>
                        <td><?= $index + 1; ?></td>
                        <td><?= $row['supplier_name']; ?></td>
                        <td><?= $row['bill_number']; ?></td>
                        <td><?= $row['product_name']; ?></td>
                        <td><?= $row['return_quantity']; ?></td>
                        <td><?= date("d-M-Y", strtotime($row['return_date'])); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else : ?>
                <tr>
                    <td colspan="6" class="text-center">No return records found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

    <div class="modal fade" id="returnModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">New Return Entry</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
    <form method="POST" action="save_return.php">
        <!-- Supplier Selection -->
        <label>Select Supplier:</label>
        <select id="supplier_id" name="supplier_id" class="form-control">
            <option value="">-- Select Supplier --</option>
            <?php foreach ($suppliers as $supplier): ?>
                <option value="<?= $supplier['supplier_id']; ?>"><?= $supplier['supplier_name']; ?></option>
            <?php endforeach; ?>
        </select>
        
        <!-- Bill Number Selection (Populated dynamically based on Supplier) -->
        <label>Select Bill Number:</label>
        <select id="bill_number" name="bill_number" class="form-control" disabled>
            <option value="">-- Select Bill Number --</option>
        </select>
        
        <!-- Books Table (Populated dynamically based on Bill Number) -->
        <div id="booksTableContainer" class="mt-4" style="display:none;">
            <h5>Books in Purchase</h5>
            <table>
                <thead>
                    <tr>
                        <th>Book Name</th>
                        <th>Quantity</th>
                        <th>Price</th>
                        <th>Return Quantity</th>
                    </tr>
                </thead>
                <tbody id="booksTableBody"></tbody>
            </table>
            <button type="submit" class="btn btn-success">Submit Return</button>
        </div>
    </form>
</div>

            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // When supplier is selected, fetch bill numbers
    $('#supplier_id').change(function() {
        let supplier_id = $(this).val();
        if (supplier_id) {
            $.post('fetch_bills.php', { supplier_id: supplier_id }, function(response) {
                $('#bill_number').html(response).prop('disabled', false);
                $('#booksTableContainer').hide();
            });
        } else {
            $('#bill_number').prop('disabled', true).html('<option value="">-- Select Bill Number --</option>');
            $('#booksTableContainer').hide();
        }
    });

    // When bill number is selected, fetch book details
    $('#bill_number').change(function() {
        let bill_number = $(this).val();
        if (bill_number) {
            $.post('fetch_books.php', { bill_number: bill_number }, function(response) {
                $('#booksTableBody').html(response);
                $('#booksTableContainer').show();
            });
        } else {
            $('#booksTableContainer').hide();
        }
    });
});


</script>




<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
