<?php



// Include database connection
include 'db.php';
include 'sidebar.php';


// Fetch sales transactions with customer name
$query = "
   
    SELECT s.sale_id, s.sale_code, s.sale_date, s.quantity, s.total_price, s.sale_type, s.receipt_status, 
           p.product_name, 
           c.customer_name 
    FROM sales_transactions s
    LEFT JOIN product_master p ON s.product_id = p.product_id
    LEFT JOIN customer_master c ON s.customer_id = c.customer_id
    ORDER BY s.sale_id DESC
";
$stmt = $pdo->query($query);
$sales = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sales Transactions</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background: #f4f4f4;
        }
        h1 {
            color: #343a40;
            text-align: center;
        }
        .add-sale-btn {
            display: inline-block;
            margin-bottom: 20px;
            padding: 10px 15px;
            background: #28a745;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            transition: background 0.3s;
        }
        .add-sale-btn:hover {
            background:rgb(19, 64, 190);
        }
      
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            font-size: 18px;
            background: white;
        }
        th, td {
            padding: 12px;
            border: 1px solid #ddd;
            text-align: center;
        }
        th {
            background: #007bff;
                color: black;
    font-size: 15px;
        }
        tr:nth-child(even) {
            background-color:rgb(197, 202, 211);
        }
        tr:hover {
            background-color: #ddd;
        }
        .center-container {
            max-width: 1200px;
            margin: auto;
        }
        button{
            background-color: #007BFF;
            color: white;
            border: none;
            cursor: pointer;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
            margin-left: 10px;
            font-size: 16px;
            font-weight: bold;
            transition: background 0.3s;
        }
        button:hover {
            background-color: #0056b3;
        }
     
         
    </style>
</head>
<body>
    <div class="center-container">
        

        <h1>Sales Transactions</h1>

        <!-- Add New Sale Button -->
        <a href="add_sale.php" class="add-sale-btn"><svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="currentColor" class="bi bi-plus-circle-dotted" viewBox="0 0 16 16">
  <path d="M8 0q-.264 0-.523.017l.064.998a7 7 0 0 1 .918 0l.064-.998A8 8 0 0 0 8 0M6.44.152q-.52.104-1.012.27l.321.948q.43-.147.884-.237L6.44.153zm4.132.271a8 8 0 0 0-1.011-.27l-.194.98q.453.09.884.237zm1.873.925a8 8 0 0 0-.906-.524l-.443.896q.413.205.793.459zM4.46.824q-.471.233-.905.524l.556.83a7 7 0 0 1 .793-.458zM2.725 1.985q-.394.346-.74.74l.752.66q.303-.345.648-.648zm11.29.74a8 8 0 0 0-.74-.74l-.66.752q.346.303.648.648zm1.161 1.735a8 8 0 0 0-.524-.905l-.83.556q.254.38.458.793l.896-.443zM1.348 3.555q-.292.433-.524.906l.896.443q.205-.413.459-.793zM.423 5.428a8 8 0 0 0-.27 1.011l.98.194q.09-.453.237-.884zM15.848 6.44a8 8 0 0 0-.27-1.012l-.948.321q.147.43.237.884zM.017 7.477a8 8 0 0 0 0 1.046l.998-.064a7 7 0 0 1 0-.918zM16 8a8 8 0 0 0-.017-.523l-.998.064a7 7 0 0 1 0 .918l.998.064A8 8 0 0 0 16 8M.152 9.56q.104.52.27 1.012l.948-.321a7 7 0 0 1-.237-.884l-.98.194zm15.425 1.012q.168-.493.27-1.011l-.98-.194q-.09.453-.237.884zM.824 11.54a8 8 0 0 0 .524.905l.83-.556a7 7 0 0 1-.458-.793zm13.828.905q.292-.434.524-.906l-.896-.443q-.205.413-.459.793zm-12.667.83q.346.394.74.74l.66-.752a7 7 0 0 1-.648-.648zm11.29.74q.394-.346.74-.74l-.752-.66q-.302.346-.648.648zm-1.735 1.161q.471-.233.905-.524l-.556-.83a7 7 0 0 1-.793.458zm-7.985-.524q.434.292.906.524l.443-.896a7 7 0 0 1-.793-.459zm1.873.925q.493.168 1.011.27l.194-.98a7 7 0 0 1-.884-.237zm4.132.271a8 8 0 0 0 1.012-.27l-.321-.948a7 7 0 0 1-.884.237l.194.98zm-2.083.135a8 8 0 0 0 1.046 0l-.064-.998a7 7 0 0 1-.918 0zM8.5 4.5a.5.5 0 0 0-1 0v3h-3a.5.5 0 0 0 0 1h3v3a.5.5 0 0 0 1 0v-3h3a.5.5 0 0 0 0-1h-3z"/>
</svg></a>
       
        <!-- Sales Transactions Table -->
        <table>
            <thead>
                <tr>
                    <th>Sale Code</th>
                    <th>Sale Date</th>
                    <th>Customer Name</th>
                    <th>Product Name</th>
                    <th>Quantity</th>
                    <th>Unit Price</th>
                    <th>Payment Type</th>
                   

                
                </tr>
            </thead>
            <tbody>
              <?php foreach ($sales as $sale) : ?>
            <tr>
                <td><?= htmlspecialchars($sale['sale_code']) ?></td>
                <td><?= htmlspecialchars($sale['sale_date']) ?></td>
                <td><?= $sale['customer_name'] ? htmlspecialchars($sale['customer_name']) : '<span style="color:red;">N/A</span>' ?></td>
                <td><?= htmlspecialchars($sale['product_name']) ?></td>
                <td><?= htmlspecialchars($sale['quantity']) ?></td>
                <td><?= htmlspecialchars($sale['total_price']) ?></td>
                <td><?= htmlspecialchars($sale['sale_type']) ?></td>
                
               
            </tr>
        <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <!-- Sales Invoice Print Button -->
    <center>
 <button onclick="printsalesinvoice()">
  <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="currentColor" class="bi bi-printer-fill" viewBox="0 0 16 16">
    <path d="M5 1a2 2 0 0 0-2 2v1h10V3a2 2 0 0 0-2-2zm6 8H5a1 1 0 0 0-1 1v3a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1v-3a1 1 0 0 0-1-1"/>
    <path d="M0 7a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v3a2 2 0 0 1-2 2h-1v-2a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v2H2a2 2 0 0 1-2-2zm2.5 1a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1"/>
  </svg>
</button>

<script>
    function printsalesinvoice() {
        var printWindow = window.open('', '', 'height=400,width=600');
        printWindow.document.write('<html><head><title>Sales Invoice</title>');
        printWindow.document.write('</head><body>');
        printWindow.document.write('<style>body {font-family: Arial, sans-serif;} h1 {text-align: center; font-size:17px;} h2 {text-align: end; font-size:17px;}</style>');
        printWindow.document.write('<style>table {width:100%;} th, td {border: 1px solid black; padding: 8px; text-align: left;} tr:nth-child(even) {background-color:rgb(16, 125, 214);}</style>');
        printWindow.document.write('<body>');
        printWindow.document.write('<h1>Tatvamasi Book Center</h1>');
        printWindow.document.write('<h1>24/48,Ramar Kovil Street,Ramnagar,Coimbatore,641009</h1>');
        printWindow.document.write('<h1>9787184200</h1>');
        printWindow.document.write('<hr>');
        printWindow.document.write('<h1>Sales Invoice</h1>');
        printWindow.document.write('<hr>');

        // Loop through each sale and display
        <?php foreach ($sales as $sale): ?>
            var invoiceNo = "<?php echo htmlspecialchars($sale['sale_code']);?>";
            var date = "<?php echo htmlspecialchars(date('d-M-Y', strtotime($sale['sale_date'])));?>";
            var customerName = "<?php echo htmlspecialchars($sale['customer_name']);?>";
            var productName = "<?php echo htmlspecialchars($sale['product_name']);?>";
            var qty = "<?php echo htmlspecialchars($sale['quantity']);?>";
            var price = "<?php echo htmlspecialchars(number_format($sale['total_price'], 2));?>";
            var totalAmount = "<?php echo htmlspecialchars(number_format($sale['total_price'], 2));?>";
            
            // Print sale details for each item
            printWindow.document.write('<h2>Date: '+ date +'</h2>');
            printWindow.document.write('<p>Invoice No: '+ invoiceNo +'</p>');
            printWindow.document.write('<p>Customer Name: '+ customerName +'</p>');
            printWindow.document.write('<hr>');
            printWindow.document.write('<table style="width:100%">');
            printWindow.document.write('<tr>');
            printWindow.document.write('<th>Product Name</th>');
            printWindow.document.write('<th>Quantity</th>');
            printWindow.document.write('<th>Price</th>');
            printWindow.document.write('<th>Total Amount</th>');
            printWindow.document.write('</tr>');
            printWindow.document.write('<tr>');
            printWindow.document.write('<td>'+ productName +'</td>');
            printWindow.document.write('<td>'+ qty +'</td>');
            printWindow.document.write('<td>'+ price +'</td>');
            printWindow.document.write('<td>'+ totalAmount +'</td>');
            printWindow.document.write('</tr>');
            printWindow.document.write('</table>');
            printWindow.document.write('<h2>Total Amount: '+ totalAmount +'</h2>');
        <?php endforeach; ?>

        printWindow.document.write('<h1>Thank You!</h1>');
        printWindow.document.write('</body></html>');
        printWindow.document.close();
        printWindow.print();
        printWindow.close();
    }
</script>

         
       
    
</body>
</html>
