<?php
session_start();
require 'db.php'; 

// If the user is not logged in, redirect to login page
if (!isset($_SESSION['sales_logged_in']) || $_SESSION['sales_logged_in'] !== true) {
    header("Location: admin_login.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sales Dashboard</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        .sidebar {
            width: 270px;
            height: 100vh;
            background: linear-gradient(135deg, #6a11cb, #2575fc);
            display: flex;
            flex-direction: column;
            position: fixed;
            top: 0;
            left: 0;
            padding: 20px;
        }
        .main-content {
            margin-left: 270px;
            padding: 20px;
            width: calc(100% - 270px);
        }
        .sidebar-footer img {
            width: 139px;
            margin-bottom: 10px;
            border-radius: 0px;
        }
        .sidebar h1 {
            font-size: 20px;
            color: #fff;
            text-align: center;
        }
        .nav-link {
            color: #f8f9fa;
            font-size: 16px;
            padding: 10px 15px;
            margin-bottom: 5px;
            border-radius: 4px;
            transition: all 0.3s ease;
        }
        .nav-link:hover {
            background-color: #ffffff;
            text-decoration: none;
        }
        .sidebar-footer {
            text-align: center;
            padding: 10px;
            border-top: 1px solid #fff;
                background: white;
        }
        .logout-button {
    width: 40px;
    position: fixed;
    top: 20px;
    right: 20px;
    border: none;
    cursor: pointer;
    text-decoration: none;
    font-weight: 500;
}
    </style>
</head>
<body>
    <div class="d-flex">
        <div class="sidebar">
            <div class="text-center">
                <img src="images/logo.webp" alt="Vivekananda Bookstall" style="
    border-radius: 138px;
    width: 90px;
">
                <h1>Tatvamasi Book Center</h1>
            </div>
            <ul class="nav flex-column">
                <li class="nav-item">
                    <a href="sales.php" class="nav-link"><i class="fas fa-dollar-sign"></i> Sales</a>
                </li>
                <li class="nav-item">
                    <a href="sales_report.php" class="nav-link"><i class="fas fa-chart-bar"></i> Sales Report</a>
                </li>
            </ul>
            <div class="sidebar-footer">
                <a href="https://kalpavrukshaits.com/">
               <img src="images/logo.jpg" alt="Footer Logo"></a>
            </div>
        </div>
        <div class="main-content">
           <!-- Add the logout button at the top-right of the page -->
<a href="logout.php">
</h2><img src="images/shutdown.png" alt="logoutimg" class="logout-button"style="
    width: 40px;
"></a>
            <h2>Welcome to the Sales Dashboard</h2>
            
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
