<?php
// Enable detailed error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include database connection
include 'db.php';
include 'sidebar.php';

$from_date = $_GET['from_date'] ?? '';
$to_date = $_GET['to_date'] ?? '';

try {
    $query = "SELECT 
        s.sale_id,
        s.sale_code,
        s.invoice_number,
        s.sale_date,
        s.quantity,
        s.total_price,
        s.total_amount,
        s.sale_type,
        s.receipt_status,
        c.customer_name,
        p.product_name
    FROM 
        sales_transactions s
    LEFT JOIN customer_master c ON s.customer_id = c.customer_id
    LEFT JOIN product_master p ON s.product_id = p.product_id";

    // Add date filter
    if (!empty($from_date) && !empty($to_date)) {
        $query .= " WHERE s.sale_date BETWEEN :from_date AND :to_date";
    }

    $query .= " ORDER BY s.sale_date DESC LIMIT 50";

    $stmt = $pdo->prepare($query);

    if (!empty($from_date) && !empty($to_date)) {
        $stmt->bindParam(':from_date', $from_date);
        $stmt->bindParam(':to_date', $to_date);
    }

    $stmt->execute();
    $sales = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("Error: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sales Transactions</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f4f4f9;
        }

        h1 {
            text-align: center;
            color: #333;
            padding: 20px 0;
            font-size: 2.5em;
        }

         .container {
        width: 90%;
        max-width: 1200px;
        margin: auto;
        
        padding: 20px;
        border-radius: 8px;
        
    }

    .search-form {
        display: flex;
        justify-content: space-between;
        align-items: flex-end;
        margin-bottom: 20px;
        
        padding: 15px;
        border-radius: 8px;
        
    }

    .form-group {
        display: flex;
        flex-direction: column;
        width: 40%; /* Reduced width */
    }

    .form-group label {
        font-size: 14px;
        margin-bottom: 5px;
        color: #555;
    }

    .form-group input {
        font-size: 14px;
        padding: 6px 10px;
        border: 1px solid #ddd;
        border-radius: 5px;
        background: #fafafa;
    }

    .form-group input:focus {
        border-color: #007bff;
        outline: none;
        background: #fff;
    }

    .button-group {
        display: flex;
        align-items: center;
    }

    .btn {
        padding: 8px 16px;
        font-size: 14px;
        margin-right: 8px;
        background-color: #007bff;
        color: white;
        border: none;
        border-radius: 5px;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    .btn:hover {
        background-color: #0056b3;
    }

    .clear-btn {
        padding: 8px 16px;
        font-size: 14px;
        background: #f1f1f1;
        color: #333;
        border: 1px solid #ddd;
        border-radius: 5px;
        cursor: pointer;
    }

    .clear-btn:hover {
        background-color: #e1e1e1;
    }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        th, td {
            padding: 12px 15px;
            border: 1px solid #ddd;
            text-align: left;
        }

        th {
            background-color: #007bff;
            color: black;
    font-size: 15px;

        }

        tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        tr:hover {
            background-color: #f1f1f1;
        }

        .no-data {
            text-align: center;
            font-size: 1.2em;
            color: #777;
            padding: 20px;
        }
    </style>
</head>
<body class="bg-light">
    <div class="container mt-4">
        <h1 class="text-center">Sales Report</h1>

        <form method="GET" class="row g-3">
            <div class="col-md-4">
                <label class="form-label">From Date</label>
                <input type="date" name="from_date" class="form-control" value="<?php echo htmlspecialchars($from_date); ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">To Date</label>
                <input type="date" name="to_date" class="form-control" value="<?php echo htmlspecialchars($to_date); ?>">
            </div>
            <div class="col-md-4 d-flex align-items-end">
                <button type="submit" class="btn btn-primary me-2">Search</button>
                <a href="sales_report.php" class="btn btn-secondary">Clear</a>
            </div>
        </form>

        <table>
            <thead>
                <tr>
                    <th>Sale Code</th>
                    <th>Customer Name</th>
                    <th>Product Name</th>
                    <th>Sale Date</th>
                    <th>Quantity</th>
                    <th>Unit Price</th>
                    <th>Payment Type</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($sales as $sale): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($sale['sale_code']); ?></td>
                        <td><?php echo htmlspecialchars($sale['customer_name'] ?? 'N/A'); ?></td>
                        <td><?php echo htmlspecialchars($sale['product_name'] ?? 'N/A'); ?></td>
                        <td><?php echo htmlspecialchars(date('d-M-Y', strtotime($sale['sale_date']))); ?></td>
                        <td><?php echo htmlspecialchars($sale['quantity']); ?></td>
                        <td><?php echo htmlspecialchars(number_format($sale['total_price'], 2)); ?></td>
                        <td><?php echo htmlspecialchars($sale['sale_type']); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
