<?php 
session_start();
require 'db.php';
include 'stock_update_logic.php';
include 'sidebar.php';

// Fetch unique invoice numbers
$invoiceQuery = "SELECT DISTINCT invoice_number FROM sales_transactions";
$invoiceStmt = $pdo->prepare($invoiceQuery);
$invoiceStmt->execute();
$invoices = $invoiceStmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch sales return details
$salesReturnQuery = "SELECT sr.return_id, sr.return_date, sr.quantity, 
                            s.invoice_number, p.product_name 
                     FROM sales_returns sr
                     JOIN sales_transactions s ON sr.sale_id = s.sale_id
                     JOIN product_master p ON s.product_id = p.product_id";

$salesReturnStmt = $pdo->prepare($salesReturnQuery);
$salesReturnStmt->execute();
$salesReturns = $salesReturnStmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Sales Returns</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
          body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
        }
        th {
            background-color:rgb(28, 139, 230);
        }
        tr:hover {
            background-color: #f1f1f1;
        }
        form {
            margin-top: 20px;
        }
        h1 {
            text-align: center;
            color: #333;
        }
    </style>
</head>
<body>
<div class="container mt-4">
    <h2 class="text-center">Sales Returns</h2>
    
    <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#returnModal">
        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" class="bi bi-plus-circle-fill" viewBox="0 0 16 16">
            <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0M8.5 4.5a.5.5 0 0 0-1 0v3h-3a.5.5 0 0 0 0 1h3v3a.5.5 0 0 0 1 0v-3h3a.5.5 0 0 0 0-1h-3z"/>
        </svg>
    </button>

    <!-- Sales Return Modal -->
    <div class="modal fade" id="returnModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">New Sales Return Entry</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form method="POST" action="save_sales_return.php">
                        <div class="mb-3">
                            <label class="form-label">Select Invoice Number:</label>
                            <select id="invoice_number" name="invoice_number" class="form-control">
                                <option value="">-- Select Invoice Number --</option>
                                <?php foreach ($invoices as $invoice): ?>
                                    <option value="<?= $invoice['invoice_number']; ?>"><?= $invoice['invoice_number']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        
                        <div id="booksTableContainer" class="mt-4" style="display:none;">
                            <h5>Books in Invoice</h5>
                            <table>
                                <thead>
                                    <tr>
                                        <th>Book Name</th>
                                        <th>Quantity</th>
                                        <th>Price</th>
                                        <th>Return Quantity</th>
                                    </tr>
                                </thead>
                                <tbody id="booksTableBody"></tbody>
                            </table>
                            <button type="submit" class="btn btn-success">Submit Return</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Sales Returns Table -->
    <h3 class="mt-5">Sales Return Records</h3>
    <table>
        <thead>
            <tr>
                <th>Return ID</th>
                <th>Return Date</th>
                <th>Invoice Number</th>
                <th>Book Name</th>
                <th>Returned Quantity</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($salesReturns as $return): ?>
                <tr>
                    <td><?= $return['return_id']; ?></td>
                    <td><?= $return['return_date']; ?></td>
                    <td><?= $return['invoice_number']; ?></td>
                    <td><?= $return['product_name']; ?></td>
                    <td><?= $return['quantity']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
$(document).ready(function() {
    $('#invoice_number').change(function() {
        let invoice_number = $(this).val();
        if (invoice_number) {
            $.ajax({
                url: 'fetch_sales_books.php',
                type: 'POST',
                data: { invoice_number: invoice_number },
                success: function(response) {
                    $('#booksTableBody').html(response);
                    $('#booksTableContainer').show();
                }
            });
        } else {
            $('#booksTableContainer').hide();
        }
    });
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
