<?php
require 'db.php';

if (isset($_POST['sale_code']) && isset($_POST['receipts'])) {
    $sale_code = $_POST['sale_code'];
    $receipts = json_decode($_POST['receipts'], true);

    if (!$receipts) {
        die("Error: No receipt data received.");
    }

    foreach ($receipts as $receipt) {
        $product_name = $receipt['book_name'];
        $total_amount = $receipt['total_amount'];
        $handover_amount = $receipt['handover_amount'];
        $balance_amount = $receipt['balance_amount'];

        // Debugging: Check if values exist
        error_log("Saving Receipt -> Sale Code: $sale_code, Book: $product_name, Total: $total_amount, Handover: $handover_amount, Balance: $balance_amount");

        // Save receipt data in branch_sales_receipt table
        $query = "INSERT INTO branch_sales_receipt (sale_code, product_name, total_amount, handover_amount, balance_amount)
                  VALUES (:sale_code, :product_name, :total_amount, :handover_amount, :balance_amount)";
        $stmt = $pdo->prepare($query);
        $result = $stmt->execute([
            ':sale_code' => $sale_code,
            ':product_name' => $product_name,
            ':total_amount' => $total_amount,
            ':handover_amount' => $handover_amount,
            ':balance_amount' => $balance_amount
        ]);

        if (!$result) {
            die("Error: Failed to save receipt.");
        }
    }

    echo "Receipt saved successfully!";
} else {
    die("Error: Sale Code or Receipts not received.");
}
?>
