<?php

include 'db.php';
include 'stock_update_logic.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdo->beginTransaction(); // Start transaction

        $supplier_id = $_POST['supplier_id'] ?? null;
        $bill_number = $_POST['bill_number'] ?? null;
        $return_quantities = $_POST['return_quantity'] ?? [];

        if (!$supplier_id || !$bill_number || empty($return_quantities)) {
            throw new Exception("Missing required fields.");
        }

        // Prepare insert query
        $insertQuery = "INSERT INTO purchase_returns (supplier_id, bill_number, product_id, return_quantity, return_date) 
                        VALUES (:supplier_id, :bill_number, :product_id, :return_quantity, NOW())";
        $insertStmt = $pdo->prepare($insertQuery);

        // Prepare update query for product_master
        $updateQuery = "UPDATE product_master SET stock = stock - :return_quantity WHERE product_id = :product_id";
        $updateStmt = $pdo->prepare($updateQuery);

        foreach ($return_quantities as $product_id => $return_quantity) {
    if (!empty($product_id) && !empty($return_quantity)) {
        $return_quantity = (int)$return_quantity; // Convert to integer

        // ✅ Insert return details into purchase_returns table
        $insertStmt->execute([
            ':supplier_id' => $supplier_id,
            ':bill_number' => $bill_number,
            ':product_id' => $product_id,
            ':return_quantity' => $return_quantity
        ]);

        // ✅ Update stock in product_master table
        if (!updateStockAfterPurchaseReturn($product_id, $return_quantity)) {
            echo "<script>alert('❌ Error updating stock for Product ID $product_id.');</script>";
        }
    }
}


            

                // Update stock in product_master
                

        $pdo->commit();
        echo "<script>
                alert('Return saved successfully and stock updated!');
                window.location.href = 'returns.php'; 
              </script>";
        exit();
    } catch (Exception $e) {
        $pdo->rollBack();
        echo "<script>
                alert('Error: " . $e->getMessage() . "');
                window.location.href = 'returns.php'; 
              </script>";
        exit();
    }
}


?>
