<?php

echo "<pre>";
print_r($_POST);
echo "</pre>";
exit;
// Include database connection
include 'db.php';
include 'stock_update_logic.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve form data
    $sale_date = $_POST['sale_date'];
    $customer_name = trim($_POST['customer_name']); // Trim spaces
    $payment_type = $_POST['payment_type']; 
    $receipt_status = $_POST['receipt_status']; 
    $products = $_POST['product_name'];
    $quantities = $_POST['quantity'];
    $prices = $_POST['price'];

    try {
        // Start a transaction
        $pdo->beginTransaction();

       // Fetch customer ID by name
// Ensure the customer name is coming from the form
$customer_name = $_POST['customer_name'] ?? '';

// Fetch customer ID from customer_master table
$customerStmt = $pdo->prepare("SELECT customer_id FROM customer_master WHERE customer_name = :customer_name LIMIT 1");
$customerStmt->execute([':customer_name' => $customer_name]);
$customer = $customerStmt->fetch(PDO::FETCH_ASSOC);

if (!$customer) {
    die("Error: Customer not found in database!");  // Stop execution if customer is not found
}

$customer_id = $customer['customer_id']; // Correctly store the customer ID


        // Generate a unique sale code
        $saleCodeStmt = $pdo->query("SELECT MAX(sale_id) as max_id FROM sales_transactions");
        $lastSale = $saleCodeStmt->fetch(PDO::FETCH_ASSOC);
        $newSaleCode = 'SC-' . str_pad(($lastSale['max_id'] ?? 0) + 1, 4, '0', STR_PAD_LEFT);

        // Insert each product into sales_transactions
        $query = "
            INSERT INTO sales_transactions 
            (sale_code, product_id, customer_id, sale_date, quantity, total_price, sale_type, receipt_status) 
            VALUES 
            (:sale_code, :product_id, :customer_id, :sale_date, :quantity, :total_price, :sale_type, :receipt_status)
        ";
        $stmt = $pdo->prepare($query);

        foreach ($products as $index => $productName) {
            // Fetch product ID by name
            $productStmt = $pdo->prepare("SELECT product_id FROM product_master WHERE product_name = :product_name");
            $productStmt->execute([':product_name' => $productName]);
            $product = $productStmt->fetch(PDO::FETCH_ASSOC);

            if (!$product) {
                throw new Exception("Product '$productName' not found.");
            }

            $product_id = $product['product_id'];
            $quantity = $quantities[$index];
            $price = $prices[$index];

            // Execute the insert
          $stmt->execute([
    ':sale_code' => $newSaleCode,
    ':product_id' => $product_id,
    ':customer_id' => $customer_id,
    ':sale_date' => $sale_date,
    ':quantity' => $quantity,
    ':total_price' => $quantity * $price,  // Correct total price calculation
    ':sale_type' => $payment_type,
    ':receipt_status' => $receipt_status,
]);

updateStockAfterSale($product_id, $quantity);

        }
        

        // Commit the transaction
        $pdo->commit();

        // Redirect to sales.php
        header('Location: sales.php?success=1');
        exit;
    } catch (Exception $e) {
        $pdo->rollBack();
        error_log("Error: " . $e->getMessage());
        echo "Error: " . $e->getMessage();
    }
} else {
    echo "Invalid request.";
}
?>
