<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'db.php';
include 'stock_update_logic.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdo->beginTransaction(); // Start transaction

        $invoice_number = $_POST['invoice_number'] ?? null;
        $product_ids = $_POST['product_id'] ?? [];
        $return_quantities = $_POST['return_quantity'] ?? [];

        if (!$invoice_number || empty($product_ids)) {
            throw new Exception("Missing required fields.");
        }

        // Fetch all sales with this invoice number
        $saleQuery = "SELECT sale_id, product_id FROM sales_transactions WHERE invoice_number = :invoice_number";
        $saleStmt = $pdo->prepare($saleQuery);
        $saleStmt->execute([':invoice_number' => $invoice_number]);
        $sales = $saleStmt->fetchAll(PDO::FETCH_ASSOC);

        if (!$sales) {
            throw new Exception("No sales found for invoice number: $invoice_number");
        }

        // Prepare queries
        $insertQuery = "INSERT INTO sales_returns (sale_id, return_date, quantity, invoice_number) 
                        VALUES (:sale_id, NOW(), :quantity, :invoice_number)";
        $insertStmt = $pdo->prepare($insertQuery);

        $updateQuery = "UPDATE product_master SET stock = stock + :return_quantity WHERE product_id = :product_id";
        $updateStmt = $pdo->prepare($updateQuery);

        foreach ($product_ids as $key => $product_id) {
            if (!empty($product_id) && !empty($return_quantities[$key])) {
                $return_quantity = (int)$return_quantities[$key];

                if ($return_quantity > 0) {
                    // Find correct sale_id for this product
                    $matchingSale = array_filter($sales, function ($sale) use ($product_id) {
                        return $sale['product_id'] == $product_id;
                    });

                    if (!$matchingSale) {
                        throw new Exception("No matching sale found for product ID: $product_id");
                    }

                    $sale_id = array_values($matchingSale)[0]['sale_id'];

                    // Insert into sales_returns
                    $insertStmt->execute([
                        ':sale_id' => $sale_id,
                        ':quantity' => $return_quantity,
                        ':invoice_number' => $invoice_number
                    ]);

                    // Update stock
                    $updateStmt->execute([
                        ':product_id' => $product_id,
                        ':return_quantity' => $return_quantity
                    ]);

                    // Call stock update function
                    updateStockAfterSalesReturn($product_id, $return_quantity);
                }
            }
        }

        $pdo->commit(); // Commit transaction
        echo "<script>
                alert('Return saved successfully and stock updated!');
                window.location.href = 'sales_returns.php'; 
              </script>";
        exit();
    } catch (Exception $e) {
        $pdo->rollBack(); // Rollback transaction on error
        echo "Error: " . $e->getMessage();
        exit();
    }
}
?>
