<?php
// Database connection
include 'db.php'; // Ensure `db.php` initializes `$pdo`

// Function to update stock after purchase
function updateStockAfterPurchase($product_id, $quantity) {
    global $pdo; // ✅ Use the same $pdo connection

    if (!$pdo) {
        die("Error: Database connection is missing in stock_update_logic.php");
    }

    $stmt = $pdo->prepare("UPDATE product_master SET stock = stock + :quantity WHERE product_id = :product_id");
    $stmt->execute([
        ':quantity' => $quantity,
        ':product_id' => $product_id
    ]);
}

function updateStockAfterPurchaseReturn($product_id, $quantity) {
    global $pdo;

    // ✅ Check if product exists before updating stock
    $stmt = $pdo->prepare("SELECT stock FROM product_master WHERE product_id = ?");
    $stmt->execute([$product_id]);
    $product = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$product) {
        error_log("❌ Error: Product ID $product_id does not exist in product_master.\n", 3, "stock_log.txt");
        return false; // Stop execution if product does not exist
    }

    // ✅ Check if quantity is valid
    if ($quantity <= 0) {
        error_log("❌ Error: Invalid return quantity ($quantity) for Product ID $product_id.\n", 3, "stock_log.txt");
        return false;
    }

    // ✅ Update stock (subtract returned quantity)
    $updateStmt = $pdo->prepare("UPDATE product_master SET stock = stock - :quantity WHERE product_id = :product_id");
    $updateStmt->execute([
        ':quantity' => $quantity,
        ':product_id' => $product_id
    ]);

    return true;
}


// Function to update stock after sale
function updateStockAfterSale($product_id, $quantity) {
    global $pdo;
    
    $stmt = $pdo->prepare("UPDATE product_master SET stock = stock - :quantity WHERE product_id = :product_id");
    $stmt->execute([
        ':quantity' => $quantity,
        ':product_id' => $product_id
    ]);
}

// Function to update stock after sales return
function updateStockAfterSalesReturn($sale_id, $quantity) {
    global $pdo;

    // Fetch product_id using sale_id
    $stmt = $pdo->prepare("SELECT product_id FROM sales_transactions WHERE sale_id = ?");
    $stmt->execute([$sale_id]);
    $product = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($product) {
        $product_id = $product['product_id'];

        // Update stock
        $updateStmt = $pdo->prepare("UPDATE product_master SET stock = stock + :quantity WHERE product_id = :product_id");
        $updateStmt->execute([
            ':quantity' => $quantity,
            ':product_id' => $product_id
        ]);
    } else {
        error_log("Error: No product found for Sale ID: $sale_id", 3, "stock_log.txt");
    }
}

?>

