<?php
include 'sidebar.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Supplier Master</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
    <style>
  body {
            font-family: Arial, sans-serif;
            margin: 20px;
        }
h2{
    text-align: center;
    color: #343a40;
}
          table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 18px;
            

        }
        th, td {
            border: 1px solid #ddd;
          

        }
        th {
            background: #007bff;
            color: black;
            width: 15%;
            text-align: left;
            padding: 10px;
                font-size: 15px;

           
        }
        td {
           
            padding: 8px;
            
           
        }
        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        td:nth-child(4) {
            text-align: right;
        }
        td:nth-child(5) {
            text-align: left;
        }
        td:nth-child(6) {
            text-align: left;
        }
        td:nth-child(7) {
            text-align: left;
        }
        tr:hover {
            background-color: #f1f1f1;
        }


    </style>

<body>
    <div class="container mt-5">
        <h2>Supplier Master</h2>
 <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#supplierModal" ><svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" class="bi bi-plus-circle-fill" viewBox="0 0 16 16">
  <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0M8.5 4.5a.5.5 0 0 0-1 0v3h-3a.5.5 0 0 0 0 1h3v3a.5.5 0 0 0 1 0v-3h3a.5.5 0 0 0 0-1h-3z"/>
</svg></button>
        <!-- Supplier List Table -->
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Supplier Name</th>
                    <th>Address</th>
                    <th>City</th>
                    <th>Pincode</th>
                    <th>Email</th>
                    <th>Contact Person</th>
                    <th>Mobile Number</th>
                </tr>
            </thead>
            <tbody>
                <?php
                
                include 'db.php';
                $sql = "SELECT * FROM supplier_master";
                $stmt = $pdo->query($sql);
                $suppliers = $stmt->fetchAll();

                if ($suppliers) {
                    foreach ($suppliers as $index => $supplier) {
                        echo "<tr>
                            <td>" . ($index + 1) . "</td>
                            <td>" . htmlspecialchars($supplier['supplier_name']) . "</td>
                            <td>" . htmlspecialchars($supplier['address']) . "</td>
                            <td>" . htmlspecialchars($supplier['city']) . "</td>
                            <td>" . htmlspecialchars($supplier['pincode']) . "</td>
                            <td>" . htmlspecialchars($supplier['email_id']) . "</td>
                            <td>" . htmlspecialchars($supplier['contact_person_name']) . "</td>
                            <td>" . htmlspecialchars($supplier['mobile_number']) . "</td>
                        </tr>";
                    }
                } else {
                    echo "<tr><td colspan='8' class='text-center'>No suppliers found.</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>

    <!-- Modal for Adding Supplier -->
    <div class="modal fade" id="supplierModal" tabindex="-1" aria-labelledby="supplierModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="supplierModalLabel">Add New Supplier</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form method="POST" action="supplier_master.php">
                        <div class="row mb-3">
                            <label for="supplierName" class="col-sm-3 col-form-label">Supplier Name</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" id="supplierName" name="supplier_name" required>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="contactPerson" class="col-sm-3 col-form-label">Contact Person</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" id="contactPerson" name="contact_person_name" required>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="email" class="col-sm-3 col-form-label">Email</label>
                            <div class="col-sm-9">
                                <input type="email" class="form-control" id="email" name="email_id" required>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="mobileNumber" class="col-sm-3 col-form-label">Mobile Number</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" id="mobileNumber" name="mobile_number" required>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="address" class="col-sm-3 col-form-label">Address</label>
                            <div class="col-sm-9">
                                <textarea class="form-control" id="address" name="address" required></textarea>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="city" class="col-sm-3 col-form-label">City</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" id="city" name="city" required>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="pincode" class="col-sm-3 col-form-label">Pincode</label>
                            <div class="col-sm-9">
                                <input type="text" class="form-control" id="pincode" name="pincode" required>
                            </div>
                        </div>
                        <div class="text-end">
                            <button type="submit" class="btn btn-primary" name="add_supplier">Save Supplier</button>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

   
</body>
</html>
<?php



if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_supplier'])) {
    $supplier_name = $_POST['supplier_name'] ?? '';
    $address = $_POST['address'] ?? '';
    $city = $_POST['city'] ?? '';
    $pincode = $_POST['pincode'] ?? '';
    $email_id = $_POST['email_id'] ?? '';
    $contact_person_name = $_POST['contact_person_name'] ?? '';
    $mobile_number = $_POST['mobile_number'] ?? '';

    try {
        $sql = "INSERT INTO supplier_master (supplier_name, address, city, pincode, email_id, contact_person_name, mobile_number)
        VALUES (:supplier_name, :address, :city, :pincode, :email_id, :contact_person_name, :mobile_number)";

        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':supplier_name' => $supplier_name,
            ':address' => $address,
            ':city' => $city,
            ':pincode' => $pincode,
            ':email_id' => $email_id,
            ':contact_person_name' => $contact_person_name,
            ':mobile_number' => $mobile_number
        ]);
        echo "<script>alert('Supplier added successfully!'); window.location.href='supplier_master.php';</script>";
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}
?>
