<?php
include 'sidebar.php';



$host = 'localhost';
$db = 'bookstore_dashboard';
$user = 'bookstore_dashboard';
$pass = '9(AhSb@uHXMUk0wK';

try {
    $pdo = new PDO('mysql:host=localhost;dbname=bookstore_dashboard', 'bookstore_dashboard', '9(AhSb@uHXMUk0wK');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$query = "
SELECT 
    pt.purchase_number,
    pt.purchase_date,
    pt.bill_number,
    pt.total_cost,
    sm.supplier_name,
    sm.address AS supplier_address,
    sm.city,
    sm.pincode,
    GROUP_CONCAT(CONCAT(pm.product_name, ' (', pi.quantity, ')')) AS product_details
FROM 
    purchase_transactions pt
JOIN 
    supplier_master sm ON pt.supplier_id = sm.supplier_id
LEFT JOIN 
    purchase_items pi ON pt.purchase_id = pi.purchase_id
LEFT JOIN 
    product_master pm ON pi.product_id = pm.product_id
GROUP BY 
    pt.purchase_id";



    $stmt = $pdo->query($query);
    $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // ... (Rest of the HTML code as before) ...

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <title>Transaction History</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background: #f4f4f4;
        }
        h1 {
            text-align: center;
        }
        
        .add-sale-btn {
    display: inline-block;
    margin-bottom: 20px;
    padding: 10px 15px;
    background: #28a745;
    color: white;
    text-decoration: none;
    border-radius: 5px;
    font-size: 16px;
    font-weight: bold;
    transition: background 0.3s;
}
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
            font-size: 18px;
            background: white;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #007bff;
            color: black;
            font-size: 15px;
        }
        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        tr:hover {
            background-color: #f1f1f1;
        }
    </style>
</head>
<body>
    <h1>Transaction History</h1>

    <div class="button-container">
        
        <a href="add_transaction.php" class="add-sale-btn"><svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" fill="currentColor" class="bi bi-plus-circle-dotted" viewBox="0 0 16 16">
  <path d="M8 0q-.264 0-.523.017l.064.998a7 7 0 0 1 .918 0l.064-.998A8 8 0 0 0 8 0M6.44.152q-.52.104-1.012.27l.321.948q.43-.147.884-.237L6.44.153zm4.132.271a8 8 0 0 0-1.011-.27l-.194.98q.453.09.884.237zm1.873.925a8 8 0 0 0-.906-.524l-.443.896q.413.205.793.459zM4.46.824q-.471.233-.905.524l.556.83a7 7 0 0 1 .793-.458zM2.725 1.985q-.394.346-.74.74l.752.66q.303-.345.648-.648zm11.29.74a8 8 0 0 0-.74-.74l-.66.752q.346.303.648.648zm1.161 1.735a8 8 0 0 0-.524-.905l-.83.556q.254.38.458.793l.896-.443zM1.348 3.555q-.292.433-.524.906l.896.443q.205-.413.459-.793zM.423 5.428a8 8 0 0 0-.27 1.011l.98.194q.09-.453.237-.884zM15.848 6.44a8 8 0 0 0-.27-1.012l-.948.321q.147.43.237.884zM.017 7.477a8 8 0 0 0 0 1.046l.998-.064a7 7 0 0 1 0-.918zM16 8a8 8 0 0 0-.017-.523l-.998.064a7 7 0 0 1 0 .918l.998.064A8 8 0 0 0 16 8M.152 9.56q.104.52.27 1.012l.948-.321a7 7 0 0 1-.237-.884l-.98.194zm15.425 1.012q.168-.493.27-1.011l-.98-.194q-.09.453-.237.884zM.824 11.54a8 8 0 0 0 .524.905l.83-.556a7 7 0 0 1-.458-.793zm13.828.905q.292-.434.524-.906l-.896-.443q-.205.413-.459.793zm-12.667.83q.346.394.74.74l.66-.752a7 7 0 0 1-.648-.648zm11.29.74q.394-.346.74-.74l-.752-.66q-.302.346-.648.648zm-1.735 1.161q.471-.233.905-.524l-.556-.83a7 7 0 0 1-.793.458zm-7.985-.524q.434.292.906.524l.443-.896a7 7 0 0 1-.793-.459zm1.873.925q.493.168 1.011.27l.194-.98a7 7 0 0 1-.884-.237zm4.132.271a8 8 0 0 0 1.012-.27l-.321-.948a7 7 0 0 1-.884.237l.194.98zm-2.083.135a8 8 0 0 0 1.046 0l-.064-.998a7 7 0 0 1-.918 0zM8.5 4.5a.5.5 0 0 0-1 0v3h-3a.5.5 0 0 0 0 1h3v3a.5.5 0 0 0 1 0v-3h3a.5.5 0 0 0 0-1h-3z"/>
</svg></a>
    </div>

    <table>
        <thead>
            <tr>
                <th>Purchase Number</th>
                <th>Date</th>
                <th>Bill Number</th>
                <th>Supplier</th>
                <th>Supplier Address</th>
                <th>Total Cost</th>
                <th>Books</th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($transactions) > 0): ?>
                <?php foreach ($transactions as $transaction): ?>
                    <tr>
                        <td><?= htmlspecialchars($transaction['purchase_number']) ?></td>
                        <td><?= htmlspecialchars($transaction['purchase_date']) ?></td>
                        <td><?= htmlspecialchars($transaction['bill_number']) ?></td>
                        <td><?= htmlspecialchars($transaction['supplier_name']) ?></td>
                        <td><?= htmlspecialchars($transaction['supplier_address']) ?></td>
                        
                        
                        <td>₹<?= number_format((float)$transaction['total_cost'], 2) ?></td>
                        <td><?= htmlspecialchars($transaction['product_details']) ?></td>

                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="9" style="text-align: center;">No transactions found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

</body>
</html>