<?php
require 'db.php';

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['receipt_id'])) {
    $receipt_id = $_POST['receipt_id'];
    $handover_amount = $_POST['handover_amount'];
    $balance_amount = $_POST['balance_amount'];

    // Fetch total amount from database
    $query = "SELECT total_amount FROM branch_sales_receipt WHERE receipt_id = ?";
    $stmt = $pdo->prepare($query);
    $stmt->execute([$receipt_id]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$result) {
        die("Error: No receipt found for ID $receipt_id");
    }

    $total_amount = $result['total_amount'];

    // Set status based on payment
    if ($handover_amount >= $total_amount) {
        $status = 'Paid';
    } else {
        $status = 'Unpaid';
    }

    // Update receipt status
    $updateQuery = "UPDATE branch_sales_receipt 
                    SET handover_amount = ?, balance_amount = ?, receipt_status = ? 
                    WHERE receipt_id = ?";
    $stmt = $pdo->prepare($updateQuery);
    
    if ($stmt->execute([$handover_amount, $balance_amount, $status, $receipt_id])) {
        
        // Also update branch_sales
        $updateBranchQuery = "UPDATE branch_sales 
                              SET receipt_status = ? 
                              WHERE sale_code = (SELECT sale_code FROM branch_sales_receipt WHERE receipt_id = ?)";
        $stmt = $pdo->prepare($updateBranchQuery);
        $stmt->execute([$status, $receipt_id]);

        echo "success";
    } else {
        $errorInfo = $stmt->errorInfo();
        die("SQL Error: " . $errorInfo[2]); // Show SQL error
    }
} else {
    die("Invalid Request");
}
?>
