<?php
session_start();
include 'db.php';

// --- Simple login credentials ---
$USERNAME = "admin";
$PASSWORD = "12345"; // change later for security

// Handle login form
if (isset($_POST['login'])) {
    if ($_POST['username'] === $USERNAME && $_POST['password'] === $PASSWORD) {
        $_SESSION['loggedin'] = true;
        header("Location: dashboard.php");
        exit;
    } else {
        $error = "Invalid username or password.";
    }
}

// Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: dashboard.php");
    exit;
}

// If not logged in, show login form
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true):
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Admin Login - Sri Venkateshwara Catering</title>
<link rel="stylesheet" href="../assets/css/bootstrap.min.css">
<link rel="stylesheet" href="../assets/css/font-awesome.css">
<style>
body { background: #fffaf8; font-family: 'Poppins', sans-serif; color: #333; }
.login-container { display:flex; align-items:center; justify-content:center; min-height:100vh; }
.login-box { background:#fff; padding:40px; border-radius:12px; box-shadow:0 6px 18px rgba(0,0,0,0.08); max-width:380px; width:100%; text-align:center; }
.login-box h2 { color:#cd3131; margin-bottom:20px; font-weight:600; }
.form-control { border-radius:8px; }
.btn-login { background:#cd3131; border:none; color:#fff; padding:10px 18px; border-radius:8px; width:100%; font-weight:500; }
.error { color:#c00; margin-bottom:12px; }
</style>
</head>
<body>
<div class="login-container">
  <div class="login-box">
    <h2>Admin Login</h2>
    <?php if(isset($error)): ?>
      <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>
    <form method="post">
      <div class="mb-3">
        <input type="text" name="username" class="form-control" placeholder="Username" required>
      </div>
      <div class="mb-3">
        <input type="password" name="password" class="form-control" placeholder="Password" required>
      </div>
      <button type="submit" name="login" class="btn-login">Login</button>
    </form>
  </div>
</div>
</body>
</html>
<?php
exit;
endif;

// ---------- Logged-in area below ----------

// Upload images/videos
if(isset($_FILES['media'])){
    $uploadDir = 'uploads/';
    if(!is_dir($uploadDir)){
        mkdir($uploadDir, 0755, true);
    }
    foreach($_FILES['media']['tmp_name'] as $index => $tmpName){
        if($_FILES['media']['error'][$index] === UPLOAD_ERR_OK){
            $filename = time() . '_' . basename($_FILES['media']['name'][$index]);
            $targetFile = $uploadDir . $filename;
            $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
            
            if(move_uploaded_file($tmpName, $targetFile)){
                // Store in appropriate table based on file type
                if(in_array($ext, ['mp4', 'webm', 'ogg', 'avi', 'mov'])){
                    $stmt = $pdo->prepare("INSERT INTO videos (filename) VALUES (?)");
                    $stmt->execute([$filename]);
                } else if(in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp', 'bmp'])){
                    $stmt = $pdo->prepare("INSERT INTO images (filename) VALUES (?)");
                    $stmt->execute([$filename]);
                }
            }
        }
    }
    header('Location: dashboard.php');
    exit;
}

// Delete media
if(isset($_GET['delete'])){
    $id = intval($_GET['delete']);
    $type = $_GET['type'] ?? 'image';
    $table = ($type === 'video') ? 'videos' : 'images';
    
    $stmt = $pdo->prepare("SELECT filename FROM $table WHERE id = ?");
    $stmt->execute([$id]);
    $media = $stmt->fetch();
    if($media){
        @unlink('uploads/'.$media['filename']);
        $stmt = $pdo->prepare("DELETE FROM $table WHERE id = ?");
        $stmt->execute([$id]);
    }
    header('Location: dashboard.php');
    exit;
}

// Fetch all media
$images = $pdo->query("SELECT *, 'image' as type FROM images ORDER BY uploaded_at DESC")->fetchAll();
$videos = $pdo->query("SELECT *, 'video' as type FROM videos ORDER BY uploaded_at DESC")->fetchAll();
$mediaFiles = array_merge($images, $videos);
// Sort by uploaded_at
usort($mediaFiles, function($a, $b) {
    return strtotime($b['uploaded_at']) - strtotime($a['uploaded_at']);
});
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="stylesheet" href="../assets/css/bootstrap.min.css">
<link rel="stylesheet" href="../assets/css/font-awesome.css">
<title>Gallery Dashboard</title>
<style>
body { background:#fffaf8; font-family:'Poppins', sans-serif; }
.card-img-top { width:100%; height:200px; object-fit:cover; }
.card video { width:100%; height:auto; max-height:250px; }
.card { border-radius:10px; overflow:hidden; box-shadow:0 4px 12px rgba(0,0,0,0.08); transition:transform .3s; }
.card:hover { transform:translateY(-5px); box-shadow:0 6px 18px rgba(0,0,0,0.12); }
.btn-danger { background:#cd3131; border:none; }
.btn-danger:hover { background:#a82828; }
h1 { color:#31542a; font-weight:600; margin-bottom:30px; }
h5 { color:#31542a; font-weight:600; margin-top:40px; margin-bottom:20px; }
.upload-box { background:#fff; padding:25px; border-radius:10px; box-shadow:0 4px 12px rgba(0,0,0,0.06); }
.logout-btn { position:absolute; top:20px; right:20px; }
</style>
</head>
<body>
<div class="container" style="padding:60px 20px;margin-top:20px;">
  <a href="?logout" class="btn btn-sm btn-secondary logout-btn"><i class="fa fa-sign-out"></i> Logout</a>
  <h1><i class="fa fa-dashboard"></i> Gallery Management Dashboard</h1>
  <div class="upload-box mb-4">
    <h5><i class="fa fa-upload"></i> Upload Images & Videos</h5>
    <form method="post" enctype="multipart/form-data">
      <div class="mb-3">
        <label class="form-label">Select files (Images: jpg, png, gif | Videos: mp4, webm, ogg)</label>
        <input type="file" name="media[]" multiple required class="form-control" accept="image/*,video/*">
      </div>
      <button type="submit" class="btn btn-danger"><i class="fa fa-upload"></i> Upload Media</button>
    </form>
  </div>

  <h4>Uploaded Media (<?= count($mediaFiles) ?> items)</h4>
  
  <!-- Images Section -->
  <h5 class="mt-4"><i class="fa fa-image"></i> Images (<?= count($images) ?>)</h5>
  <div class="row">
  <?php if(count($images) > 0): ?>
    <?php foreach($images as $img): ?>
      <div class="col-md-3 mb-3">
        <div class="card">
          <img src="uploads/<?= htmlspecialchars($img['filename']) ?>" class="card-img-top" alt="Gallery Image">
          <div class="card-body text-center">
            <small class="text-muted d-block mb-2"><?= date('M d, Y', strtotime($img['uploaded_at'])) ?></small>
            <a href="?delete=<?= $img['id'] ?>&type=image" onclick="return confirm('Delete this image?')" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i> Delete</a>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  <?php else: ?>
    <div class="col-12"><p class="text-muted">No images uploaded yet.</p></div>
  <?php endif; ?>
  </div>

  <!-- Videos Section -->
  <h5 class="mt-4"><i class="fa fa-video-camera"></i> Videos (<?= count($videos) ?>)</h5>
  <div class="row">
  <?php if(count($videos) > 0): ?>
    <?php foreach($videos as $video): 
        $ext = strtolower(pathinfo($video['filename'], PATHINFO_EXTENSION));
    ?>
      <div class="col-md-4 mb-3">
        <div class="card">
          <video class="card-img-top" controls>
            <source src="uploads/<?= htmlspecialchars($video['filename']) ?>" type="video/<?= $ext ?>">
            Your browser does not support the video tag.
          </video>
          <div class="card-body text-center">
            <small class="text-muted d-block mb-2"><?= date('M d, Y', strtotime($video['uploaded_at'])) ?></small>
            <a href="?delete=<?= $video['id'] ?>&type=video" onclick="return confirm('Delete this video?')" class="btn btn-sm btn-danger"><i class="fa fa-trash"></i> Delete</a>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  <?php else: ?>
    <div class="col-12"><p class="text-muted">No videos uploaded yet.</p></div>
  <?php endif; ?>
</div>

</div>
</body>
</html>
