<?php
include 'db.php';
$images = $pdo->query("SELECT * FROM images ORDER BY uploaded_at DESC")->fetchAll();
$videos = $pdo->query("SELECT * FROM videos ORDER BY uploaded_at DESC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="stylesheet" href="../assets/css/animate.css">
    <link rel="stylesheet" href="../assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="../assets/css/magnific-popup.min.css">
    <link rel="stylesheet" href="../assets/css/nice-select.min.css">
    <link rel="stylesheet" href="../assets/css/font-awesome.css">
    <link rel="stylesheet" href="../assets/css/swiper.min.css">
    <link rel="stylesheet" href="../assets/css/font.css">
    <link rel="stylesheet" href="../assets/css/main-style.css">

    <link rel="stylesheet" id="color-change" type="text/css" href="#">

    <link rel="shortcut icon" type="image/ico" href="../assets/images/main/favicon.ico" />
    <title> Sri Venkateshwara Catering </title>



    <style>
        .cat-gallery-wrapper{
            padding:150px 0;
            background:#fffaf8;
            position:relative;
            
        }
        .cat-gallery-wrapper .cat-heading-wrapper{
            text-align:center;
            margin-bottom:50px;
        }
        .cat-gallery-grid{
            display:grid;
            grid-template-columns:repeat(auto-fill,minmax(280px,1fr));
            gap:25px;
        }
        .cat-gallery-item{
            overflow:hidden;
            position:relative;
            border-radius:10px;
            box-shadow:0 6px 20px rgba(0,0,0,0.06);
            transition:transform .3s ease, box-shadow .3s ease;
        }
        .cat-gallery-item:hover{
            transform:translateY(-5px);
            box-shadow:0 10px 24px rgba(0,0,0,0.12);
        }
        .cat-gallery-item img{
            width:100%;
            height:250px;
            object-fit:cover;
            display:block;
            border-radius:10px;
        }
        .cat-gallery-item .overlay{
            position:absolute;
            inset:0;
            background:#31542a9e;
            color:#fff;
            display:flex;
            align-items:center;
            justify-content:center;
            opacity:0;
            transition:opacity .3s ease;
            font-size:32px;
        }
        .cat-gallery-item:hover .overlay{
            opacity:1;
        }
        .cat-gallery-item.hidden{
            display:none;
        }
        .load-more-btn{
            text-align:center;
            margin-top:40px;
        }
        .load-more-btn .cat-btn{
            background:#31542a;
            color:#fff;
            padding:12px 40px;
            border-radius:5px;
            border:none;
            cursor:pointer;
            font-size:16px;
            font-weight:600;
            transition:all .3s ease;
        }
        .load-more-btn .cat-btn:hover{
            background:#243d1f;
            transform:translateY(-2px);
        }
        .cat-video-wrapper{
            padding:100px 0;
            background:#fff;
            position:relative;
        }
        .cat-video-wrapper .cat-heading-wrapper{
            text-align:center;
            margin-bottom:50px;
        }
        .cat-video-grid{
            display:grid;
            grid-template-columns:repeat(auto-fill,minmax(350px,1fr));
            gap:30px;
        }
        .cat-video-item{
            overflow:hidden;
            position:relative;
            border-radius:10px;
            box-shadow:0 6px 20px rgba(0,0,0,0.06);
            transition:transform .3s ease, box-shadow .3s ease;
        }
        .cat-video-item:hover{
            transform:translateY(-5px);
            box-shadow:0 10px 24px rgba(0,0,0,0.12);
        }
        .cat-video-item video{
            width:100%;
            height:280px;
            object-fit:cover;
            display:block;
            border-radius:10px;
        }
    </style>
</head>

<body>
    <!-- Header -->
    <header>
        <div class="header-wrapper">
            <div class="container">
                <div class="row">
                    <div class="col-xl-2 col-lg-3 col-md-3 col-sm-4 col-4">
                        <div class="cat-logo-wrapper">
                            <img src="../assets/images/svc.png">
                            
                          
                        </div>
                    </div>
                    <div class="col-xl-10 col-lg-9 col-md-9 col-sm-8 col-8">
                        <div class="main-menu-container">
                            <div class="main-menu">
                                <ul>
                                    <li><a href="index.html">Home</a></li>
                                    <li class="active"><a href="gallery.php">Gallery</a></li>
                                    <li><a href="#">Events</a></li>
                                    <li><a href="#">About Us</a></li>
                                    <li><a href="#">Contact Us</a></li>
                                </ul>
                            </div>
                            <div class="menu-btn-wrap">
                                <a href="javascript:void(0);" class="search-btn">
                                    <img src="../assets/images/main/search.svg" alt="">
                                </a>
                                <a href="javascript:void(0);" class="menu-btn">
                                    <span></span><span></span><span></span>
                                </a>
                            </div>
                            <a href="#" class="cat-btn header-btn">Get Free Quote</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Gallery Section -->
    <section class="cat-gallery-wrapper">
        <div class="container">
            <div class="cat-heading-wrapper">
                <h4>Photo Collection</h4>
                <h2>Our Gallery</h2>
                <p>Captured moments from our events and catering services.</p>
            </div>
            <div class="cat-gallery-grid popup-gallery">
                <?php if(count($images) > 0): ?>
                    <?php foreach($images as $index => $img): ?>
                        <a href="uploads/<?= htmlspecialchars($img['filename']); ?>" class="cat-gallery-item <?= $index >= 9 ? 'hidden' : ''; ?>" data-index="<?= $index; ?>">
                            <img src="uploads/<?= htmlspecialchars($img['filename']); ?>" alt="Gallery Image">
                            <div class="overlay"><i class="fa fa-search-plus"></i></div>
                        </a>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p style="text-align:center;color:#888;">No images uploaded yet. Please check back soon.</p>
                <?php endif; ?>
            </div>
            <?php if(count($images) > 9): ?>
            <div class="load-more-btn">
                <button class="cat-btn" id="loadMoreBtn">Load More</button>
            </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- Videos Section -->
    <section class="cat-video-wrapper">
        <div class="container">
            <div class="cat-heading-wrapper">
                <h4>Video Collection</h4>
                <h2>Our Videos</h2>
                <p>Watch highlights from our events and catering services.</p>
            </div>
            <div class="cat-video-grid">
                <?php if(count($videos) > 0): ?>
                    <?php foreach($videos as $video): ?>
                        <div class="cat-video-item">
                            <video controls>
                                <source src="uploads/<?= htmlspecialchars($video['filename']); ?>" type="video/mp4">
                                Your browser does not support the video tag.
                            </video>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p style="text-align:center;color:#888;grid-column:1/-1;">No videos uploaded yet. Please check back soon.</p>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="main-footer">
        <div class="cat-footer-wrapper relative">
            <div class="top-left-shap bouncing">
                <img src="../assets/images/main/shap/02.png" alt="">
            </div>
            <div class="top-right-shap bouncing">
                <img src="../assets/images/main/shap/04.png" alt="">
            </div>
            <div class="container">
                <div class="row">
                    <div class="col-xl-4 col-lg-4 col-md-6 col-12 mb-4 mb-lg-0">
                        <div class="cat-widget cat-foot-about">
                            <h4 class="footer-title">
                                About Catering
                            </h4>
                            <p>
                                Sri Venkateshwara Catering Service brings authentic South Indian flavors to your special occasions. From traditional decorations to delicious meals, we make every celebration memorable with care and perfection.
                            </p>
                           
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 col-md-6 col-12 mb-4 mb-lg-0">
                        <div class="cat-widget cat-foot-menu">
                            <h4 class="footer-title">
                                Special Facilities
                            </h4>
                            <div class="footer-menu">
                                <ul>
                                    <li>
                                        <a href="javascript:void(0);">
                                            <span>
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="28" height="18" viewBox="0 0 28 18" xml:space="preserve"><path d="M27.6,8.5c-5.5,0-9.5-8.1-9.5-8.2C17.9,0,17.7,0,17.5,0.1c-0.2,0.1-0.3,0.4-0.1,0.7c0.1,0.3,2.7,5.5,6.7,7.7H0.4C0.2,8.5,0,8.7,0,9c0,0.3,0.2,0.5,0.4,0.5h23.7c-4,2.2-6.6,7.4-6.7,7.7c-0.1,0.2,0,0.5,0.1,0.7c0.2,0.1,0.4,0.1,0.6-0.2c0-0.1,4.1-8.2,9.5-8.2C27.8,9.5,28,9.3,28,9C28,8.7,27.8,8.5,27.6,8.5z"></path><path d="M27.6,8.5c-5.5,0-9.5-8.1-9.5-8.2C17.9,0,17.7,0,17.5,0.1c-0.2,0.1-0.3,0.4-0.1,0.7c0.1,0.3,2.7,5.5,6.7,7.7H0.4C0.2,8.5,0,8.7,0,9c0,0.3,0.2,0.5,0.4,0.5h23.7c-4,2.2-6.6,7.4-6.7,7.7c-0.1,0.2,0,0.5,0.1,0.7c0.2,0.1,0.4,0.1,0.6-0.2c0-0.1,4.1-8.2,9.5-8.2C27.8,9.5,28,9.3,28,9C28,8.7,27.8,8.5,27.6,8.5z"></path></svg>
                                            </span>
                                            <p>
                                                Weddings
                                            </p>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);">
                                            <span>
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="28" height="18" viewBox="0 0 28 18" xml:space="preserve"><path d="M27.6,8.5c-5.5,0-9.5-8.1-9.5-8.2C17.9,0,17.7,0,17.5,0.1c-0.2,0.1-0.3,0.4-0.1,0.7c0.1,0.3,2.7,5.5,6.7,7.7H0.4C0.2,8.5,0,8.7,0,9c0,0.3,0.2,0.5,0.4,0.5h23.7c-4,2.2-6.6,7.4-6.7,7.7c-0.1,0.2,0,0.5,0.1,0.7c0.2,0.1,0.4,0.1,0.6-0.2c0-0.1,4.1-8.2,9.5-8.2C27.8,9.5,28,9.3,28,9C28,8.7,27.8,8.5,27.6,8.5z"></path><path d="M27.6,8.5c-5.5,0-9.5-8.1-9.5-8.2C17.9,0,17.7,0,17.5,0.1c-0.2,0.1-0.3,0.4-0.1,0.7c0.1,0.3,2.7,5.5,6.7,7.7H0.4C0.2,8.5,0,8.7,0,9c0,0.3,0.2,0.5,0.4,0.5h23.7c-4,2.2-6.6,7.4-6.7,7.7c-0.1,0.2,0,0.5,0.1,0.7c0.2,0.1,0.4,0.1,0.6-0.2c0-0.1,4.1-8.2,9.5-8.2C27.8,9.5,28,9.3,28,9C28,8.7,27.8,8.5,27.6,8.5z"></path></svg>
                                            </span>
                                            <p>
House warmings</p>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);">
                                            <span>
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="28" height="18" viewBox="0 0 28 18" xml:space="preserve"><path d="M27.6,8.5c-5.5,0-9.5-8.1-9.5-8.2C17.9,0,17.7,0,17.5,0.1c-0.2,0.1-0.3,0.4-0.1,0.7c0.1,0.3,2.7,5.5,6.7,7.7H0.4C0.2,8.5,0,8.7,0,9c0,0.3,0.2,0.5,0.4,0.5h23.7c-4,2.2-6.6,7.4-6.7,7.7c-0.1,0.2,0,0.5,0.1,0.7c0.2,0.1,0.4,0.1,0.6-0.2c0-0.1,4.1-8.2,9.5-8.2C27.8,9.5,28,9.3,28,9C28,8.7,27.8,8.5,27.6,8.5z"></path><path d="M27.6,8.5c-5.5,0-9.5-8.1-9.5-8.2C17.9,0,17.7,0,17.5,0.1c-0.2,0.1-0.3,0.4-0.1,0.7c0.1,0.3,2.7,5.5,6.7,7.7H0.4C0.2,8.5,0,8.7,0,9c0,0.3,0.2,0.5,0.4,0.5h23.7c-4,2.2-6.6,7.4-6.7,7.7c-0.1,0.2,0,0.5,0.1,0.7c0.2,0.1,0.4,0.1,0.6-0.2c0-0.1,4.1-8.2,9.5-8.2C27.8,9.5,28,9.3,28,9C28,8.7,27.8,8.5,27.6,8.5z"></path></svg>
                                            </span>
                                            <p>
                                                Upanayanam
                                            </p>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);">
                                            <span>
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="28" height="18" viewBox="0 0 28 18" xml:space="preserve"><path d="M27.6,8.5c-5.5,0-9.5-8.1-9.5-8.2C17.9,0,17.7,0,17.5,0.1c-0.2,0.1-0.3,0.4-0.1,0.7c0.1,0.3,2.7,5.5,6.7,7.7H0.4C0.2,8.5,0,8.7,0,9c0,0.3,0.2,0.5,0.4,0.5h23.7c-4,2.2-6.6,7.4-6.7,7.7c-0.1,0.2,0,0.5,0.1,0.7c0.2,0.1,0.4,0.1,0.6-0.2c0-0.1,4.1-8.2,9.5-8.2C27.8,9.5,28,9.3,28,9C28,8.7,27.8,8.5,27.6,8.5z"></path><path d="M27.6,8.5c-5.5,0-9.5-8.1-9.5-8.2C17.9,0,17.7,0,17.5,0.1c-0.2,0.1-0.3,0.4-0.1,0.7c0.1,0.3,2.7,5.5,6.7,7.7H0.4C0.2,8.5,0,8.7,0,9c0,0.3,0.2,0.5,0.4,0.5h23.7c-4,2.2-6.6,7.4-6.7,7.7c-0.1,0.2,0,0.5,0.1,0.7c0.2,0.1,0.4,0.1,0.6-0.2c0-0.1,4.1-8.2,9.5-8.2C27.8,9.5,28,9.3,28,9C28,8.7,27.8,8.5,27.6,8.5z"></path></svg>
                                            </span>
                                            <p>
                                               Sashtuapthapoorthi
                                            </p>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0);">
                                            <span>
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="28" height="18" viewBox="0 0 28 18" xml:space="preserve"><path d="M27.6,8.5c-5.5,0-9.5-8.1-9.5-8.2C17.9,0,17.7,0,17.5,0.1c-0.2,0.1-0.3,0.4-0.1,0.7c0.1,0.3,2.7,5.5,6.7,7.7H0.4C0.2,8.5,0,8.7,0,9c0,0.3,0.2,0.5,0.4,0.5h23.7c-4,2.2-6.6,7.4-6.7,7.7c-0.1,0.2,0,0.5,0.1,0.7c0.2,0.1,0.4,0.1,0.6-0.2c0-0.1,4.1-8.2,9.5-8.2C27.8,9.5,28,9.3,28,9C28,8.7,27.8,8.5,27.6,8.5z"></path><path d="M27.6,8.5c-5.5,0-9.5-8.1-9.5-8.2C17.9,0,17.7,0,17.5,0.1c-0.2,0.1-0.3,0.4-0.1,0.7c0.1,0.3,2.7,5.5,6.7,7.7H0.4C0.2,8.5,0,8.7,0,9c0,0.3,0.2,0.5,0.4,0.5h23.7c-4,2.2-6.6,7.4-6.7,7.7c-0.1,0.2,0,0.5,0.1,0.7c0.2,0.1,0.4,0.1,0.6-0.2c0-0.1,4.1-8.2,9.5-8.2C27.8,9.5,28,9.3,28,9C28,8.7,27.8,8.5,27.6,8.5z"></path></svg>
                                            </span>
                                            <p>
                                               Sadhabishegam
                                            </p>
                                        </a>
                                    </li>
                                     <li>
                                        <a href="javascript:void(0);">
                                            <span>
                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="28" height="18" viewBox="0 0 28 18" xml:space="preserve"><path d="M27.6,8.5c-5.5,0-9.5-8.1-9.5-8.2C17.9,0,17.7,0,17.5,0.1c-0.2,0.1-0.3,0.4-0.1,0.7c0.1,0.3,2.7,5.5,6.7,7.7H0.4C0.2,8.5,0,8.7,0,9c0,0.3,0.2,0.5,0.4,0.5h23.7c-4,2.2-6.6,7.4-6.7,7.7c-0.1,0.2,0,0.5,0.1,0.7c0.2,0.1,0.4,0.1,0.6-0.2c0-0.1,4.1-8.2,9.5-8.2C27.8,9.5,28,9.3,28,9C28,8.7,27.8,8.5,27.6,8.5z"></path><path d="M27.6,8.5c-5.5,0-9.5-8.1-9.5-8.2C17.9,0,17.7,0,17.5,0.1c-0.2,0.1-0.3,0.4-0.1,0.7c0.1,0.3,2.7,5.5,6.7,7.7H0.4C0.2,8.5,0,8.7,0,9c0,0.3,0.2,0.5,0.4,0.5h23.7c-4,2.2-6.6,7.4-6.7,7.7c-0.1,0.2,0,0.5,0.1,0.7c0.2,0.1,0.4,0.1,0.6-0.2c0-0.1,4.1-8.2,9.5-8.2C27.8,9.5,28,9.3,28,9C28,8.7,27.8,8.5,27.6,8.5z"></path></svg>
                                            </span>
                                            <p>
                                               Business event
                                            </p>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-4 col-md-6 col-12">
                        <div class="cat-widget cat-foot-menu">
                            <h4 class="footer-title">
                                Contact Us
                            </h4>
                            <div class="footer-menu contact-menu">
                                <ul>
                                    <li>
                                        <a href="javascript:void(0);">
                                            <span>
                                                <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 511.999 511.999" xml:space="preserve">
                                                    <g>
                                                        <g>
                                                            <path d="M256.98,40.005c-5.53-0.04-10.04,4.41-10.08,9.93c-0.04,5.52,4.4,10.03,9.93,10.07c5.52,0.04,10.03-4.4,10.07-9.92
                                                                C266.94,44.565,262.5,40.055,256.98,40.005z"/>
                                                        </g>
                                                    </g>
                                                    <g>
                                                        <g>
                                                            <path d="M256.525,100.004c-38.611-0.274-70.232,30.875-70.524,69.474c-0.291,38.597,30.875,70.233,69.474,70.524
                                                                c0.179,0.001,0.357,0.002,0.536,0.002c38.353,0,69.698-31.056,69.988-69.476C326.29,131.933,295.125,100.295,256.525,100.004z
                                                                 M256.009,220.005c-0.126,0-0.258-0.001-0.384-0.002c-27.571-0.208-49.833-22.806-49.625-50.375
                                                                c0.207-27.445,22.595-49.627,49.991-49.627c0.126,0,0.258,0.001,0.384,0.002c27.571,0.208,49.833,22.806,49.625,50.375
                                                                C305.792,197.823,283.405,220.005,256.009,220.005z"/>
                                                        </g>
                                                    </g>
                                                    <g>
                                                        <g>
                                                            <path d="M299.631,47.589c-5.202-1.846-10.921,0.879-12.767,6.085c-1.845,5.206,0.88,10.921,6.085,12.767
                                                                c44.047,15.611,73.402,57.562,73.05,104.389c-0.041,5.522,4.402,10.033,9.925,10.075c0.025,0,0.051,0,0.077,0
                                                                c5.486,0,9.956-4.428,9.998-9.925C386.415,115.633,351.706,66.046,299.631,47.589z"/>
                                                        </g>
                                                    </g>
                                                    <g>
                                                        <g>
                                                            <path d="M317.357,376.442c66.513-85.615,108.08-130.26,108.641-205.164C426.702,77.035,350.22,0,255.984,0
                                                                C162.848,0,86.71,75.428,86.002,168.728c-0.572,76.935,41.767,121.519,108.739,207.7C128.116,386.384,86.002,411.401,86.002,442
                                                                c0,20.497,18.946,38.89,53.349,51.79c31.313,11.742,72.74,18.209,116.649,18.209s85.336-6.467,116.649-18.209
                                                                c34.403-12.901,53.349-31.294,53.349-51.791C425.998,411.417,383.923,386.406,317.357,376.442z M106.001,168.879
                                                                C106.625,86.55,173.8,20,255.986,20c83.159,0,150.633,67.988,150.013,151.129c-0.532,71.134-44.614,114.971-114.991,206.714
                                                                c-12.553,16.356-24.081,31.82-34.993,46.947c-10.88-15.136-22.178-30.323-34.919-46.953
                                                                C147.81,282.253,105.459,241.729,106.001,168.879z M256,492c-85.851,0-149.999-26.397-149.999-50
                                                                c0-17.504,38.348-39.616,102.826-47.273c14.253,18.701,26.749,35.691,39.005,53.043c1.872,2.65,4.914,4.228,8.159,4.23
                                                                c0.003,0,0.006,0,0.009,0c3.242,0,6.283-1.572,8.158-4.217c12.14-17.126,24.978-34.535,39.109-53.045
                                                                c64.418,7.665,102.732,29.77,102.732,47.263C405.998,465.603,341.851,492,256,492z"/>
                                                        </g>
                                                    </g>
                                                </svg>
                                            </span>
                                            <p>No-57 , Sri Garden Village Nagar,Kurumbapalayam , Coimbatore - 641107</p>
                                        </a>
                                    </li>

                                     <li>
                                        <a href="tel:+91 9486557831">
                                            <span>
                                                <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 473.806 473.806" xml:space="preserve">
                                                    <g>
                                                        <g>
                                                            <path d="M374.456,293.506c-9.7-10.1-21.4-15.5-33.8-15.5c-12.3,0-24.1,5.3-34.2,15.4l-31.6,31.5c-2.6-1.4-5.2-2.7-7.7-4
                                                                c-3.6-1.8-7-3.5-9.9-5.3c-29.6-18.8-56.5-43.3-82.3-75c-12.5-15.8-20.9-29.1-27-42.6c8.2-7.5,15.8-15.3,23.2-22.8
                                                                c2.8-2.8,5.6-5.7,8.4-8.5c21-21,21-48.2,0-69.2l-27.3-27.3c-3.1-3.1-6.3-6.3-9.3-9.5c-6-6.2-12.3-12.6-18.8-18.6
                                                                c-9.7-9.6-21.3-14.7-33.5-14.7s-24,5.1-34,14.7c-0.1,0.1-0.1,0.1-0.2,0.2l-34,34.3c-12.8,12.8-20.1,28.4-21.7,46.5
                                                                c-2.4,29.2,6.2,56.4,12.8,74.2c16.2,43.7,40.4,84.2,76.5,127.6c43.8,52.3,96.5,93.6,156.7,122.7c23,10.9,53.7,23.8,88,26
                                                                c2.1,0.1,4.3,0.2,6.3,0.2c23.1,0,42.5-8.3,57.7-24.8c0.1-0.2,0.3-0.3,0.4-0.5c5.2-6.3,11.2-12,17.5-18.1c4.3-4.1,8.7-8.4,13-12.9
                                                                c9.9-10.3,15.1-22.3,15.1-34.6c0-12.4-5.3-24.3-15.4-34.3L374.456,293.506z M410.256,398.806
                                                                C410.156,398.806,410.156,398.906,410.256,398.806c-3.9,4.2-7.9,8-12.2,12.2c-6.5,6.2-13.1,12.7-19.3,20
                                                                c-10.1,10.8-22,15.9-37.6,15.9c-1.5,0-3.1,0-4.6-0.1c-29.7-1.9-57.3-13.5-78-23.4c-56.6-27.4-106.3-66.3-147.6-115.6
                                                                c-34.1-41.1-56.9-79.1-72-119.9c-9.3-24.9-12.7-44.3-11.2-62.6c1-11.7,5.5-21.4,13.8-29.7l34.1-34.1c4.9-4.6,10.1-7.1,15.2-7.1
                                                                c6.3,0,11.4,3.8,14.6,7c0.1,0.1,0.2,0.2,0.3,0.3c6.1,5.7,11.9,11.6,18,17.9c3.1,3.2,6.3,6.4,9.5,9.7l27.3,27.3
                                                                c10.6,10.6,10.6,20.4,0,31c-2.9,2.9-5.7,5.8-8.6,8.6c-8.4,8.6-16.4,16.6-25.1,24.4c-0.2,0.2-0.4,0.3-0.5,0.5
                                                                c-8.6,8.6-7,17-5.2,22.7c0.1,0.3,0.2,0.6,0.3,0.9c7.1,17.2,17.1,33.4,32.3,52.7l0.1,0.1c27.6,34,56.7,60.5,88.8,80.8
                                                                c4.1,2.6,8.3,4.7,12.3,6.7c3.6,1.8,7,3.5,9.9,5.3c0.4,0.2,0.8,0.5,1.2,0.7c3.4,1.7,6.6,2.5,9.9,2.5c8.3,0,13.5-5.2,15.2-6.9
                                                                l34.2-34.2c3.4-3.4,8.8-7.5,15.1-7.5c6.2,0,11.3,3.9,14.4,7.3c0.1,0.1,0.1,0.1,0.2,0.2l55.1,55.1
                                                                C420.456,377.706,420.456,388.206,410.256,398.806z"/>
                                                            <path d="M256.056,112.706c26.2,4.4,50,16.8,69,35.8s31.3,42.8,35.8,69c1.1,6.6,6.8,11.2,13.3,11.2c0.8,0,1.5-0.1,2.3-0.2
                                                                c7.4-1.2,12.3-8.2,11.1-15.6c-5.4-31.7-20.4-60.6-43.3-83.5s-51.8-37.9-83.5-43.3c-7.4-1.2-14.3,3.7-15.6,11
                                                                S248.656,111.506,256.056,112.706z"/>
                                                            <path d="M473.256,209.006c-8.9-52.2-33.5-99.7-71.3-137.5s-85.3-62.4-137.5-71.3c-7.3-1.3-14.2,3.7-15.5,11
                                                                c-1.2,7.4,3.7,14.3,11.1,15.6c46.6,7.9,89.1,30,122.9,63.7c33.8,33.8,55.8,76.3,63.7,122.9c1.1,6.6,6.8,11.2,13.3,11.2
                                                                c0.8,0,1.5-0.1,2.3-0.2C469.556,223.306,474.556,216.306,473.256,209.006z"/>
                                                        </g>
                                                    </g>
                                                </svg>
                                            </span>
                                            <p>(+91) 9486557831 -> Bharathwaj</p>
                                        </a>
                                    </li>

                                    <li>
                                        <a href="tel:+91 9842257831">
                                            <span>
                                                <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 473.806 473.806" xml:space="preserve">
                                                    <g>
                                                        <g>
                                                            <path d="M374.456,293.506c-9.7-10.1-21.4-15.5-33.8-15.5c-12.3,0-24.1,5.3-34.2,15.4l-31.6,31.5c-2.6-1.4-5.2-2.7-7.7-4
                                                                c-3.6-1.8-7-3.5-9.9-5.3c-29.6-18.8-56.5-43.3-82.3-75c-12.5-15.8-20.9-29.1-27-42.6c8.2-7.5,15.8-15.3,23.2-22.8
                                                                c2.8-2.8,5.6-5.7,8.4-8.5c21-21,21-48.2,0-69.2l-27.3-27.3c-3.1-3.1-6.3-6.3-9.3-9.5c-6-6.2-12.3-12.6-18.8-18.6
                                                                c-9.7-9.6-21.3-14.7-33.5-14.7s-24,5.1-34,14.7c-0.1,0.1-0.1,0.1-0.2,0.2l-34,34.3c-12.8,12.8-20.1,28.4-21.7,46.5
                                                                c-2.4,29.2,6.2,56.4,12.8,74.2c16.2,43.7,40.4,84.2,76.5,127.6c43.8,52.3,96.5,93.6,156.7,122.7c23,10.9,53.7,23.8,88,26
                                                                c2.1,0.1,4.3,0.2,6.3,0.2c23.1,0,42.5-8.3,57.7-24.8c0.1-0.2,0.3-0.3,0.4-0.5c5.2-6.3,11.2-12,17.5-18.1c4.3-4.1,8.7-8.4,13-12.9
                                                                c9.9-10.3,15.1-22.3,15.1-34.6c0-12.4-5.3-24.3-15.4-34.3L374.456,293.506z M410.256,398.806
                                                                C410.156,398.806,410.156,398.906,410.256,398.806c-3.9,4.2-7.9,8-12.2,12.2c-6.5,6.2-13.1,12.7-19.3,20
                                                                c-10.1,10.8-22,15.9-37.6,15.9c-1.5,0-3.1,0-4.6-0.1c-29.7-1.9-57.3-13.5-78-23.4c-56.6-27.4-106.3-66.3-147.6-115.6
                                                                c-34.1-41.1-56.9-79.1-72-119.9c-9.3-24.9-12.7-44.3-11.2-62.6c1-11.7,5.5-21.4,13.8-29.7l34.1-34.1c4.9-4.6,10.1-7.1,15.2-7.1
                                                                c6.3,0,11.4,3.8,14.6,7c0.1,0.1,0.2,0.2,0.3,0.3c6.1,5.7,11.9,11.6,18,17.9c3.1,3.2,6.3,6.4,9.5,9.7l27.3,27.3
                                                                c10.6,10.6,10.6,20.4,0,31c-2.9,2.9-5.7,5.8-8.6,8.6c-8.4,8.6-16.4,16.6-25.1,24.4c-0.2,0.2-0.4,0.3-0.5,0.5
                                                                c-8.6,8.6-7,17-5.2,22.7c0.1,0.3,0.2,0.6,0.3,0.9c7.1,17.2,17.1,33.4,32.3,52.7l0.1,0.1c27.6,34,56.7,60.5,88.8,80.8
                                                                c4.1,2.6,8.3,4.7,12.3,6.7c3.6,1.8,7,3.5,9.9,5.3c0.4,0.2,0.8,0.5,1.2,0.7c3.4,1.7,6.6,2.5,9.9,2.5c8.3,0,13.5-5.2,15.2-6.9
                                                                l34.2-34.2c3.4-3.4,8.8-7.5,15.1-7.5c6.2,0,11.3,3.9,14.4,7.3c0.1,0.1,0.1,0.1,0.2,0.2l55.1,55.1
                                                                C420.456,377.706,420.456,388.206,410.256,398.806z"/>
                                                            <path d="M256.056,112.706c26.2,4.4,50,16.8,69,35.8s31.3,42.8,35.8,69c1.1,6.6,6.8,11.2,13.3,11.2c0.8,0,1.5-0.1,2.3-0.2
                                                                c7.4-1.2,12.3-8.2,11.1-15.6c-5.4-31.7-20.4-60.6-43.3-83.5s-51.8-37.9-83.5-43.3c-7.4-1.2-14.3,3.7-15.6,11
                                                                S248.656,111.506,256.056,112.706z"/>
                                                            <path d="M473.256,209.006c-8.9-52.2-33.5-99.7-71.3-137.5s-85.3-62.4-137.5-71.3c-7.3-1.3-14.2,3.7-15.5,11
                                                                c-1.2,7.4,3.7,14.3,11.1,15.6c46.6,7.9,89.1,30,122.9,63.7c33.8,33.8,55.8,76.3,63.7,122.9c1.1,6.6,6.8,11.2,13.3,11.2
                                                                c0.8,0,1.5-0.1,2.3-0.2C469.556,223.306,474.556,216.306,473.256,209.006z"/>
                                                        </g>
                                                    </g>
                                                </svg>
                                            </span>
                                            <p>(+91) 9842257831 -> Sathyanarayanan</p>
                                        </a>
                                    </li>


                                </ul>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
        </div>
        <div class="cat-footer-copyright">
            <p>
                Copyright &copy; 2025 Sri Venkateshwara Catering Service | All Rights Reserved | <a href="https://kalpavrukshaits.com/" style="color:white;">Kalpavrükshā IT Solutions</a>
            </p>
        </div>
    </footer>
    <!-- Scripts -->
      <a href="javascript:void(0);" class="scroll-to-topp"><span class="fa fa-angle-up"></span></a>
    <script src="../assets/js/jquery.min.js"></script>
    <script src="../assets/js/bootstrap.bundle.min.js"></script>
    <script src="../assets/js/jquery.magnific-popup.min.js"></script>
    <script>
        $(document).ready(function() {
            $('.popup-gallery').magnificPopup({
                delegate: 'a:not(.hidden)',
                type: 'image',
                gallery: { enabled: true },
                removalDelay: 300,
                mainClass: 'mfp-fade'
            });

            // Load More functionality
            let currentVisible = 9;
            const itemsPerLoad = 9;
            const totalItems = $('.cat-gallery-item').length;

            $('#loadMoreBtn').click(function() {
                const nextVisible = currentVisible + itemsPerLoad;
                
                $('.cat-gallery-item').each(function(index) {
                    if(index < nextVisible) {
                        $(this).removeClass('hidden');
                    }
                });

                currentVisible = nextVisible;

                // Hide button if all items are visible
                if(currentVisible >= totalItems) {
                    $('#loadMoreBtn').fadeOut();
                }

                // Refresh magnificPopup to include newly visible items
                $('.popup-gallery').magnificPopup('destroy');
                $('.popup-gallery').magnificPopup({
                    delegate: 'a:not(.hidden)',
                    type: 'image',
                    gallery: { enabled: true },
                    removalDelay: 300,
                    mainClass: 'mfp-fade'
                });
            });
        });
    </script>
</body>
</html>
