<?php
session_start();
include 'header.php';

// Database connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$user_id = isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : 0;
if (!$user_id) {
    echo "<div class='empty-cart'><p>Please log in to view your cart.</p></div>";
    exit;
}

// Fetch cart items joined with product info
$stmt = $conn->prepare("
    SELECT c.product_id, c.quantity, p.name AS product_name, p.price 
    FROM user_cart c
    JOIN print_products p ON c.product_id = p.id
    WHERE c.user_id = ?
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
?>

<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

<style>
body {
  font-family: 'Poppins', sans-serif;
  background: #f9fafb;
  color: #333;
}
.cart-container {
  max-width: 900px;
  margin: 40px auto;
  padding: 20px;
}
.cart-header {
  text-align: center;
  margin-bottom: 30px;
}
.cart-header h2 {
  font-size: 2rem;
  font-weight: 600;
  color: #1e293b;
}
.cart-item {
  background: #fff;
  border-radius: 16px;
  padding: 20px;
  margin-bottom: 20px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.06);
}
.cart-item h5 {
  margin-bottom: 8px;
  font-size: 1.2rem;
  font-weight: 600;
  color: #111827;
}
.cart-item p {
  margin: 3px 0;
  color: #475569;
  font-size: 0.95rem;
}
.cart-item .total {
  font-weight: 600;
  color: #2563eb;
  margin-top: 5px;
}
.empty-cart {
  text-align: center;
  color: #6b7280;
  padding: 40px 20px;
}
.empty-cart i {
  font-size: 3rem;
  color: #9ca3af;
  margin-bottom: 10px;
}
</style>

<div class="cart-container">
  <div class="cart-header">
    <h2><i class="fa fa-shopping-cart"></i> Your Cart</h2>
  </div>

<?php
if ($result->num_rows > 0) {
    $grandTotal = 0;
    while ($row = $result->fetch_assoc()) {
        $total = $row['price'] * $row['quantity'];
        $grandTotal += $total;
        echo "
        <div class='cart-item'>
          <h5>{$row['product_name']}</h5>
          <p>Quantity: {$row['quantity']}</p>
          <p>Price: ₹" . number_format($row['price'], 2) . "</p>
          <p class='total'>Total: ₹" . number_format($total, 2) . "</p>
        </div>";
    }

    echo "
    <div class='cart-summary'>
      <strong>Grand Total: ₹" . number_format($grandTotal, 2) . "</strong>
    </div>";
} else {
    echo "
    <div class='empty-cart'>
      <i class='fa fa-box-open'></i>
      <p>No items in your cart yet.</p>
    </div>";
}
$conn->close();
?>
</div>
