<?php
session_start();
include 'header.php';

// Database connection
$host = "localhost";
$db   = "savithri";
$user = "savithri";
$pass = "LU*[nrO_70]7zsR_";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Default category_id = 1 (HP Indigo - C)
$category_id = isset($_GET['cat']) ? intval($_GET['cat']) : 1;

// Get user region from session, fallback to 'Region 1'
$user_region = $_SESSION['user_region'] ?? 'Region 1';
$normalized_region = strtolower(str_replace(' ', '', $user_region));

// Validate region and select price column
if (!in_array($normalized_region, ['region1', 'region2'])) {
    $normalized_region = 'region1';
}
$price_column = ($normalized_region === 'region2') ? 'price_region' : 'price';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>HP Indigo Products</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #f5f5f5;
      font-family: 'Segoe UI', sans-serif;
      margin-bottom: 80px;
    }
    .card {
      border-radius: 15px;
      transition: 0.3s;
    }
    .card:hover {
      transform: translateY(-3px);
      box-shadow: 0 4px 10px rgba(0,0,0,0.1);
    }
    .product-title {
      font-weight: 600;
      font-size: 16px;
      color: #2c3169;
    }
    .price-per-page {
      font-size: 14px;
      color: #777;
    }
    .total {
      font-weight: bold;
      color: #70916a;
    }
    .btn-icon {
      padding: 4px 10px;
      font-size: 16px;
    }
    .page-input {
      width: 60px;
      text-align: center;
    }
    .footer-summary {
      position: fixed;
      bottom: 0;
      width: 100%;
      background: #fff;
      border-top: 1px solid #ccc;
      padding: 10px 15px;
      font-size: 14px;
      color: #333;
      box-shadow: 0 -1px 5px rgba(0,0,0,0.1);
      display: flex;
      justify-content: space-between;
      align-items: center;
      z-index: 1050;
    }
    .category-buttons {
      text-align: center;
      margin-bottom: 25px;
    }
    .category-buttons .btn {
      margin: 5px;
      border-radius: 20px;
    }
    @media (max-width: 576px) {
      .footer-summary {
        flex-direction: column;
        gap: 8px;
        text-align: center;
      }
    }
  </style>
</head>
<body>

<div class="container py-5">
  <h2 class="mb-4 text-center" style="color: #2c3169;">HP Indigo Products</h2>

  <!-- Category Switch Buttons -->
  <div class="category-buttons">
    <a href="?cat=1" class="btn btn-primary <?= ($category_id==1?'active':'') ?>">HP Indigo - C</a>
    <a href="?cat=3" class="btn btn-primary <?= ($category_id==3?'active':'') ?>">HP Indigo - NFC</a>
    <a href="?cat=4" class="btn btn-primary <?= ($category_id==4?'active':'') ?>">HP Indigo - FLO</a>
  </div>

  <div class="row">
    <?php
    $stmt = $conn->prepare("SELECT id, name, $price_column AS price FROM print_products WHERE category_id = ?");
    $stmt->bind_param("i", $category_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()):
            $row_price = floatval($row['price']);
    ?>
    <div class="col-md-6 mb-4">
      <div class="card p-3 shadow-sm h-100">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <span class="product-title" id="title-<?= $row['id'] ?>"><?= htmlspecialchars($row['name']) ?></span>
          <span id="total-<?= $row['id'] ?>" class="total">₹ 0.00</span>
        </div>
        <div class="d-flex justify-content-between align-items-center">
          <small class="price-per-page">₹ <?= number_format($row_price, 2) ?> per page</small>
          <div class="d-flex align-items-center gap-2">
            <button class="btn btn-outline-dark btn-sm btn-icon" onclick="changePages(<?= $row['id'] ?>, -1)">−</button>
            <input type="number" id="pages-<?= $row['id'] ?>" value="0" readonly class="form-control form-control-sm page-input">
            <button class="btn btn-outline-dark btn-sm btn-icon"
                    onclick="changePages(<?= $row['id'] ?>, 1)"
                    data-price="<?= $row_price ?>"
                    id="price-<?= $row['id'] ?>">+</button>
          </div>
        </div>
      </div>
    </div>
    <?php endwhile; } else { ?>
        <p class="text-center mt-3">No products available in this category.</p>
    <?php } ?>
  </div>
</div>

<!-- Footer summary -->
<div class="footer-summary" id="footer-summary">
  <div id="page-summary-text">No selection</div>
  <button class="btn btn-primary btn-sm" onclick="submitSelection()">Submit</button>
</div>

<script>
let pageSummary = {};

function changePages(id, delta) {
  const input = document.getElementById("pages-" + id);
  let pages = parseInt(input.value) || 0;
  pages = Math.max(0, pages + delta);
  input.value = pages;

  const priceBtn = document.getElementById("price-" + id);
  const price = parseFloat(priceBtn.dataset.price) || 0;
  const total = price * pages;
  document.getElementById("total-" + id).textContent = "₹ " + total.toFixed(2);

  const name = document.getElementById("title-" + id).textContent;
  if (pages > 0) {
    pageSummary[id] = { id, name, pages, price };
  } else {
    delete pageSummary[id];
  }
  updateFooterSummary();
}

function updateFooterSummary() {
  const footerText = document.getElementById("page-summary-text");
  const items = Object.values(pageSummary);
  const summaries = items.map(item => `${item.pages} page(s)`);
  const totalAmount = items.reduce((sum, item) => sum + item.pages * item.price, 0);

  footerText.textContent = items.length
    ? `Selected Pages → ${summaries.join(' | ')} | Total: ₹ ${totalAmount.toFixed(2)}`
    : 'No selection';
}

async function submitSelection() {
  if (!Object.keys(pageSummary).length) {
    alert("Please select at least one product.");
    return;
  }

  for (const item of Object.values(pageSummary)) {
    const res = await fetch("add_to_cart.php", {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify({ product_id: item.id, quantity: item.pages })
    });
    const data = await res.json();
    if (!data.success) {
      console.error("Failed to add:", item.name, data.error);
    }
  }
  await updateCartCount?.();
  alert("Products added to cart!");
}
</script>

</body>
</html>
