<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Savithri Digital Print Press | Creative Printing Solutions</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="icon" type="image/png" href="https://test.kalpavrukshaits.com/savithridigital/images/logo.jpeg">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700;800&display=swap" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <style>
    :root {
      --primary: #FF6B6B;
      --secondary:#2F2F4F ;
      --accent: #2F2F4F;
      --dark: #2F2F4F;
      --light: #2F2F4F;
      --gradient: linear-gradient(135deg, #2F2F4F, #2F2F4F);
      --gradient-2: linear-gradient(135deg, #2F2F4F, #2F2F4F);
    }
    
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    
    body {
      font-family: 'Poppins', sans-serif;
      color: #333;
      line-height: 1.6;
      background: #fff;
      overflow-x: hidden;
    }
    
    /* Header Styles */
  .header {
  background: rgba(255, 255, 255, 0.95);
  box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
  position: fixed;
  width: 100%;
  z-index: 1000;
  padding: 15px 5%;
  display: flex;
  justify-content: space-between;
  align-items: center;
}

/* LOGO + TAGLINE FIX */
.logo-container {
  display: flex;
  flex-direction: column; /* stack logo & tagline vertically */
  align-items: flex-start; /* align left */
}

.logo {
  height: 55px;
  width: auto;
  margin: 0;
  transition: transform 0.3s ease;
}

.logo:hover {
  transform: rotate(-5deg) scale(1.05);
}

.tagline {
  font-size: 14px;
  font-weight: 600;
  color: #2F2F4F;
  margin-top: 6px;
  font-family: "Poppins", sans-serif;
  letter-spacing: 0.6px;
  font-style: italic;
  line-height: 1.2;
}

/* Optional: If you have logo text beside logo image */
.logo-text {
  font-size: 1.8rem;
  font-weight: 800;
  background: var(--gradient);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
}

/* NAV BUTTONS */
.nav-buttons {
  display: flex;
  gap: 15px;
}

.btn {
  padding: 10px 25px;
  border-radius: 50px;
  font-weight: 600;
  text-decoration: none;
  transition: all 0.3s ease;
  display: inline-flex;
  align-items: center;
  justify-content: center;
  gap: 8px;
}

/* LOGIN BUTTON */
.btn-login {
  background: white;
  color: var(--dark);
  border: 2px solid var(--dark);
}

.btn-login:hover {
  background: var(--dark);
  color: white;
  transform: translateY(-2px);
}

/* REGISTER BUTTON */
.btn-register {
  background: var(--gradient);
  color: white;
  box-shadow: 0 4px 15px rgba(255, 107, 107, 0.4);
}

.btn-register:hover {
  transform: translateY(-2px);
  box-shadow: 0 6px 20px rgba(255, 107, 107, 0.6);
}

    
    /* Hero Section */
    .hero {
      min-height: 100vh;
      padding: 120px 5% 80px;
      display: flex;
      align-items: center;
      position: relative;
      overflow: hidden;
      background: linear-gradient(135deg, #f5f7fa 0%, #e4e8eb 100%);
    }
    
    .hero-content {
      max-width: 600px;
      position: relative;
      z-index: 2;
    }
    
    .announcement {
      display: inline-block;
      background: var(--gradient);
      color: white;
      padding: 8px 20px;
      border-radius: 50px;
      font-size: 0.9rem;
      font-weight: 600;
      margin-bottom: 20px;
      box-shadow: 0 4px 15px rgba(255, 107, 107, 0.3);
      animation: pulse 2s infinite;
    }
    
    @keyframes pulse {
      0% { transform: scale(1); }
      50% { transform: scale(1.05); }
      100% { transform: scale(1); }
    }
    
    .hero h1 {
      font-size: 3.5rem;
      font-weight: 800;
      margin-bottom: 20px;
      line-height: 1.2;
      color: var(--dark);
    }
    
    .hero h1 span {
      background: var(--gradient);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
    }
    
    .slogan {
      font-size: 1.3rem;
      color: #555;
      margin-bottom: 30px;
      position: relative;
      padding-left: 20px;
      border-left: 4px solid var(--accent);
    }
    
    .hero-buttons {
      display: flex;
      gap: 15px;
      margin-top: 30px;
    }
    
    .btn-explore {
      background: var(--gradient-2);
      color: white;
      padding: 15px 35px;
      font-size: 1.1rem;
      font-weight: 600;
      border-radius: 50px;
      text-decoration: none;
      display: inline-flex;
      align-items: center;
      gap: 10px;
      box-shadow: 0 10px 25px rgba(78, 205, 196, 0.4);
      transition: all 0.3s ease;
    }
    
    .btn-explore:hover {
      transform: translateY(-3px) scale(1.03);
      box-shadow: 0 15px 30px rgba(78, 205, 196, 0.6);
    }
    
    .btn-contact {
      background: white;
      color: var(--dark);
      border: 2px solid var(--dark);
      padding: 15px 25px;
      border-radius: 50px;
      font-weight: 600;
      text-decoration: none;
      transition: all 0.3s ease;
    }
    
    .btn-contact:hover {
      background: var(--dark);
      color: white;
      transform: translateY(-3px);
    }
    
    .hero-image {
      position: absolute;
      right: 5%;
      top: 50%;
      transform: translateY(-50%);
      width: 50%;
      max-width: 700px;
      animation: float 6s ease-in-out infinite;
    }
    
    @keyframes float {
      0%, 100% { transform: translateY(-50%) translateY(0); }
      50% { transform: translateY(-50%) translateY(-20px); }
    }
    
    .hero-image img {
      width: 100%;
      height: auto;
      border-radius: 20px;
      box-shadow: 0 20px 40px rgba(0,0,0,0.2);
    }
    
    /* Contact Info */
    .contact-info {
  position: fixed;
  right: 30px;
  top: 50%;
  transform: translateY(-50%);
  display: flex;
  flex-direction: column;
  gap: 20px;
  z-index: 100;
  background: rgba(255, 255, 255, 0.9);
  padding: 20px 15px;
  border-radius: 50px;
  box-shadow: 0 5px 25px rgba(0, 0, 0, 0.1);
}
    
   .contact-icon {
  width: 50px;
  height: 50px;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  color: white;
  font-size: 1.2rem;
  position: relative;
  transition: all 0.3s ease;
  text-decoration: none;
}

   .contact-icon i {
  position: relative;
  z-index: 2;
}

.contact-icon::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
  border-radius: 50%;
  z-index: 1;
  transition: all 0.3s ease;
}

    .contact-icon:hover {
      transform: translateY(-5px) scale(1.1);
      box-shadow: 0 10px 25px rgba(0,0,0,0.2);
    }
    
    .contact-icon.whatsapp::before {
  background: #25D366;
}

.contact-icon.phone::before {
  background: #FF6B6B;
}

.contact-icon.email::before {
  background: #4ECDC4;
}

    
    .contact-tooltip {
  position: absolute;
  right: 60px;
  background: white;
  padding: 8px 15px;
  border-radius: 5px;
  box-shadow: 0 5px 15px rgba(0,0,0,0.1);
  font-size: 0.9rem;
  white-space: nowrap;
  color: #333;
  opacity: 0;
  pointer-events: none;
  transition: all 0.3s ease;
  font-weight: 500;
}

.contact-icon:hover .contact-tooltip {
  opacity: 1;
  right: 65px;
}
    
    /* Floating Elements */
    .floating-elements {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      pointer-events: none;
      z-index: 1;
    }
    
    .floating-element {
      position: absolute;
      border-radius: 50%;
      background: linear-gradient(135deg, rgba(255,107,107,0.1), rgba(78,205,196,0.1));
      animation: float 15s infinite ease-in-out;
    }
    
    .floating-element:nth-child(1) {
      width: 200px;
      height: 200px;
      top: 10%;
      left: 10%;
      animation-delay: 0s;
    }
    
    .floating-element:nth-child(2) {
      width: 300px;
      height: 300px;
      bottom: 10%;
      right: 10%;
      animation-delay: 2s;
      animation-duration: 20s;
      background: linear-gradient(135deg, rgba(255,209,102,0.1), rgba(255,107,107,0.1));
    }
    
    .floating-element:nth-child(3) {
      width: 150px;
      height: 150px;
      top: 50%;
      right: 20%;
      animation-delay: 4s;
      animation-duration: 25s;
      background: linear-gradient(135deg, rgba(78,205,196,0.1), rgba(47,47,79,0.1));
    }
    
    /* Responsive Styles */
    @media (max-width: 1200px) {
      .hero h1 {
        font-size: 3rem;
      }
      
      .hero-image {
        width: 45%;
      }
    }
    
    @media (max-width: 992px) {
      .hero {
        flex-direction: column;
        text-align: center;
        padding-top: 150px;
        padding-bottom: 80px;
      }
      
      .hero-content {
        max-width: 100%;
        margin-bottom: 50px;
      }
      
      .slogan {
        padding-left: 0;
        border-left: none;
        border-bottom: 3px solid var(--accent);
        display: inline-block;
        padding-bottom: 10px;
      }
      
      .hero-buttons {
        justify-content: center;
      }
      
      .hero-image {
        position: relative;
        right: auto;
        top: 92px;
        transform: none;
        width: 100%;
        max-width: 600px;
        margin: 0 auto;
      }
      
      .contact-info {
    flex-direction: row;
    bottom: 20px;
    top: auto;
    left: 50%;
    right: auto;
    transform: translateX(-50%);
    padding: 10px 25px;
    border-radius: 40px;
  }
  
  .contact-tooltip {
    display: none;
  }
}
    
    @media (max-width: 768px) {
      .hero h1 {
        font-size: 2.5rem;
      }
      
      .slogan {
        font-size: 1.1rem;
      }
      
      .hero-buttons {
        flex-direction: column;
      }
      
      .btn-explore, .btn-contact {
        width: 100%;
        justify-content: center;
      }
      
      .header {
        padding: 15px 5%;
      }
      
      .logo {
        height: 40px;
      }
      
      .logo-text {
        font-size: 1.5rem;
      }
      
      .btn {
        padding: 8px 15px;
        font-size: 0.9rem;
      }
    }
    
    @media (max-width: 480px) {
      .logo-text {
        display: none;
      }
      
      .hero h1 {
        font-size: 2rem;
      }
      
      .announcement {
        font-size: 0.8rem;
        padding: 5px 15px;
      }
    }
  </style>
</head>
<body>
  <!-- Header with Logo and Buttons -->
  <header class="header">
  <div class="logo-container">
    <img src="https://test.kalpavrukshaits.com/savithridigital/images/logo.jpeg" 
         alt="Savithri Digital Logo" 
         class="logo">
    <p class="tagline">We Exceed Your Expectations</p>
  </div>

  <div class="nav-buttons">
    <a href="https://test.kalpavrukshaits.com/savithridigital/admin/signin.php" class="btn btn-login">
      <i class="fas fa-sign-in-alt"></i> Login
    </a>
    <a href="register.php" class="btn btn-register">
      <i class="fas fa-user-plus"></i> Register
    </a>
  </div>
</header>


  <!-- Hero Section -->
  <section class="hero">
    <!-- Floating Elements -->
    <div class="floating-elements">
      <div class="floating-element"></div>
      <div class="floating-element"></div>
      <div class="floating-element"></div>
    </div>
    
    <div class="hero-content">
      <span class="announcement">
        <i class="fas fa-tag"></i> Special Offer: Get 20% Off on Your First Order!
      </span>
      
      <h1>Transform Your Ideas into <span>Stunning Prints</span></h1>
      
      <p class="slogan">Where creativity meets precision in every print. Experience the magic of 7-color printing that brings your vision to life with vibrant colors and sharp details.</p>
      
      <div class="hero-buttons">
        <a href="#exploreFeatures" class="btn-explore">
          <span>Explore Now</span>
          <i class="fas fa-arrow-right"></i>
        </a>
        <a href="#contact" class="btn-contact">
          <i class="fas fa-phone-alt"></i> Contact Us
        </a>
      </div>
    </div>
    
    <div class="hero-image">
      <img src="https://test.kalpavrukshaits.com/savithridigital/images/homebaner.jpg" alt="Printing Press">
    </div>
    
    <!-- Contact Info -->
    <div class="contact-info">
      <a href="https://wa.link/du43uc" class="contact-icon whatsapp" target="_blank">
        <i class="fab fa-whatsapp"></i>
        <span class="contact-tooltip">Chat on WhatsApp</span>
      </a>
      <a href="tel:+919442230221" class="contact-icon phone">
        <i class="fas fa-phone"></i>
        <span class="contact-tooltip">+91 9442230221</span>
      </a>
      <a href="mailto:savithridigitalpress@gmail.com" class="contact-icon email">
        <i class="fas fa-envelope"></i>
        <span class="contact-tooltip">savithridigitalpress@gmail.com</span>
      </a>
    </div>
    <!-- Explore Features Section -->
<!-- 🔹 Explore Features Section (Hidden by Default) -->
<div id="exploreFeatures" class="container py-5 text-center">
  <h2 class="fw-bold mb-4" style="color: #7c0a02;">Our Printing Excellence</h2>
  <p class="text-muted mb-5">Explore our advanced photo printing services crafted with precision and creativity.</p>

  <div class="row g-4">
    <!-- Feature 1 -->
    <div class="col-md-6 col-lg-3">
      <div class="feature-card card h-100 border-0 shadow-sm rounded-4 overflow-hidden">
        <div class="image-container">
          <img src="images/7color.png" class="card-img-top" alt="7 Color Printing">
        </div>
        <div class="card-body text-center" style=" padding: 0px 10px; ">
          <h5 class="fw-bold mb-2" style="color: #7c0a02;">7 Color Printing</h5>
          <p class="card-text text-muted">Vibrant photo prints with stunning color accuracy and depth using advanced 7-color technology.</p>
        </div>
      </div>
    </div>

    <!-- Feature 2 -->
    <div class="col-md-6 col-lg-3">
      <div class="feature-card card h-100 border-0 shadow-sm rounded-4 overflow-hidden">
        <div class="image-container">
          <img src="images/pad-designs.png" class="card-img-top" alt="Wide Range of Pad Designs">
        </div>
        <div class="card-body text-center" style=" padding: 0px 10px; ">
          <h5 class="fw-bold mb-2" style="color: #7c0a02;">Wide Range of Pad Designs</h5>
          <p class="card-text text-muted">Choose from our exclusive pad designs to make each photo album uniquely beautiful.</p>
        </div>
      </div>
    </div>

    <!-- Feature 3 -->
    <div class="col-md-6 col-lg-3">
      <div class="feature-card card h-100 border-0 shadow-sm rounded-4 overflow-hidden">
        <div class="image-container">
          <img src="images/frame-correction.png" class="card-img-top" alt="Frame to Frame Correction">
        </div>
        <div class="card-body text-center" style=" padding: 0px 10px; ">
          <h5 class="fw-bold mb-2" style="color: #7c0a02;">Frame to Frame Correction</h5>
          <p class="card-text text-muted">Perfect alignment and flawless clarity across every frame for the most natural finish.</p>
        </div>
      </div>
    </div>

    <!-- Feature 4 -->
    <div class="col-md-6 col-lg-3">
      <div class="feature-card card h-100 border-0 shadow-sm rounded-4 overflow-hidden">
        <div class="image-container">
          <img src="images/finishing.png" class="card-img-top" alt="Precision Finishing">
        </div>
        <div class="card-body text-center" style=" padding: 0px 10px; ">
          <h5 class="fw-bold mb-2" style="color: #7c0a02;">Precision Finishing</h5>
          <p class="card-text text-muted">Professional finishing that enhances every detail, making your memories shine.</p>
        </div>
      </div>
    </div>
  </div>
</div>



<!-- 🔹 CSS -->
<style>
/* Hide by default and fade in when visible */
#exploreFeatures {
  display: none;
  opacity: 0;
  transition: opacity 0.8s ease;
}
#exploreFeatures.show {
  display: block;
  opacity: 1;
}

/* Feature Cards */
.feature-card {
  transition: all 0.4s ease;
  background-color: #fff;
  cursor: pointer;
  box-shadow: 0 8px 20px rgba(124, 10, 2, 0.2);
  margin-bottom: 23px;
    padding-bottom: 8px;
    border-radius: 18px;
}

.feature-card .image-container {
  position: relative;
  overflow: hidden;
  height: 200px;
  padding: 25px;
}
.feature-card img {
  width: 100%;
  height: 100%;
  object-fit: cover;
  transition: transform 0.6s ease;
}

.feature-card h5 {
  font-size: 1.1rem;
}
.feature-card p {
  font-size: 0.95rem;
  line-height: 1.5;
}
</style>

<!-- 🔹 JS (Handles Explore Now button click) -->
<script>
document.querySelector('.btn-explore').addEventListener('click', function(e) {
  e.preventDefault();
  const section = document.getElementById('exploreFeatures');
  section.classList.add('show');
  section.scrollIntoView({ behavior: 'smooth' });
});
</script>


  <script>
    // Smooth scrolling for anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
      anchor.addEventListener('click', function(e) {
        e.preventDefault();
        
        const targetId = this.getAttribute('href');
        if (targetId === '#') return;
        
        const targetElement = document.querySelector(targetId);
        if (targetElement) {
          window.scrollTo({
            top: targetElement.offsetTop - 100,
            behavior: 'smooth'
          });
        }
      });
    });
    
    // Animation for announcement
    const announcement = document.querySelector('.announcement');
    if (announcement) {
      setInterval(() => {
        announcement.style.animation = 'none';
        void announcement.offsetWidth; // Trigger reflow
        announcement.style.animation = 'pulse 2s infinite';
      }, 5000);
    }
    
    // Parallax effect for hero image
    window.addEventListener('mousemove', (e) => {
      const heroImage = document.querySelector('.hero-image');
      if (heroImage) {
        const x = (window.innerWidth - e.pageX) / 50;
        const y = (window.innerHeight - e.pageY) / 50;
        heroImage.style.transform = `translate(0, -50%) translateX(${x/2}px) translateY(${y/2}px)`;
      }
    });
  </script>
</body>
</html>