<?php 
session_start();
include 'header.php';
// DB connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

// Fetch enabled offer images from offer_slider
$offers = $conn->query("SELECT image_url FROM offer_slider WHERE status = 'enabled'");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Savithri Digital - Premium Printing Solutions</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
  <link rel="stylesheet" href="style.css">
  <style>
    :root {
      --primary: #FF6B6B;
      --secondary: #4ECDC4;
      --accent: #FFD166;
      --dark: #2F2F4F;
      --light: #F8F9FA;
      --gradient: linear-gradient(135deg, #FF6B6B, #FF8E53);
      --gradient-2: linear-gradient(135deg, #4ECDC4, #45B7D1);
    }
    
    body {
      background: #f8f9fa;
      font-family: 'Poppins', sans-serif;
      padding-bottom: 80px;
    }
    
    /* Header Styles */
    .header {
      background: rgba(255, 255, 255, 0.98);
      box-shadow: 0 2px 15px rgba(0, 0, 0, 0.1);
      position: sticky;
      top: 0;
      z-index: 1000;
    }
    
    .logo {
      height: 40px;
      margin-right: 10px;
    }
    
    .logo-text {
      font-size: 1.5rem;
      font-weight: 700;
      background: var(--gradient);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
    }
    
    .cart-badge {
      position: absolute;
      top: -5px;
      right: -5px;
      background: var(--primary);
      color: white;
      border-radius: 50%;
      width: 20px;
      height: 20px;
      font-size: 0.7rem;
      display: flex;
      align-items: center;
      justify-content: center;
    }
    
    /* Hero Slider */
    .hero-slider {
      border-radius: 20px;
      overflow: hidden;
      box-shadow: 0 15px 30px rgba(0,0,0,0.1);
      margin: 20px 0 30px;
    }
    
    .carousel-item img {
      height: 200px;
      object-fit: cover;
    }
    
    .carousel-control-prev, 
    .carousel-control-next {
      width: 40px;
      height: 40px;
      background: rgba(0,0,0,0.2);
      border-radius: 50%;
      top: 50%;
      transform: translateY(-50%);
      opacity: 1;
    }
    
    .carousel-control-prev {
      left: 15px;
    }
    
    .carousel-control-next {
      right: 15px;
    }
    
    /* Category Cards */
    .category-grid {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 15px;
      margin: 20px 0;
    }
    
    @media (min-width: 768px) {
      .category-grid {
        grid-template-columns: repeat(4, 1fr);
      }
    }
    
    .category-card {
      background: white;
      border-radius: 16px;
      overflow: hidden;
      box-shadow: 0 5px 15px rgba(0,0,0,0.05);
      transition: all 0.3s ease;
      position: relative;
      height: 100%;
      display: flex;
      flex-direction: column;
    }
    
    .category-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    }
    
    .category-img {
      height: 120px;
      background: #f8f9fa;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 20px;
    }
    
    .category-img img {
      max-width: 100%;
      max-height: 100%;
      object-fit: contain;
      transition: transform 0.3s ease;
    }
    
    .category-card:hover .category-img img {
      transform: scale(1.1);
    }
    
    .category-body {
      padding: 15px;
      text-align: center;
      flex-grow: 1;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
    }
    
    .category-title {
      font-weight: 600;
      margin-bottom: 10px;
      color: var(--dark);
    }
    
    .category-btn {
      background: var(--gradient);
      color: white;
      border: none;
      border-radius: 50px;
      padding: 6px 15px;
      font-size: 0.85rem;
      font-weight: 500;
      transition: all 0.3s ease;
      text-decoration: none;
      display: inline-block;
      margin-top: 10px;
    }
    
    .category-btn:hover {
      color: white;
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(255, 107, 107, 0.3);
    }
    
    /* Special Offer Banner */
    .offer-banner {
      background: var(--gradient-2);
      border-radius: 16px;
      padding: 20px;
      color: white;
      margin: 30px 0;
      position: relative;
      overflow: hidden;
    }
    
    .offer-banner::before {
      content: '';
      position: absolute;
      top: -50%;
      right: -50%;
      width: 200px;
      height: 200px;
      background: rgba(255,255,255,0.1);
      border-radius: 50%;
    }
    
    .offer-banner h4 {
      font-weight: 700;
      margin-bottom: 8px;
      position: relative;
      z-index: 1;
    }
    
    .offer-banner p {
      margin-bottom: 15px;
      opacity: 0.9;
      position: relative;
      z-index: 1;
    }
    
    .offer-btn {
      background: white;
      color: var(--dark);
      border: none;
      border-radius: 50px;
      padding: 8px 20px;
      font-weight: 600;
      transition: all 0.3s ease;
      position: relative;
      z-index: 1;
    }
    
    .offer-btn:hover {
      background: var(--dark);
      color: white;
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    
    /* Bottom Navigation */
    .bottom-nav {
      position: fixed;
      bottom: 0;
      left: 0;
      width: 100%;
      background: white;
      box-shadow: 0 -5px 15px rgba(0,0,0,0.05);
      padding: 10px 0;
      z-index: 1000;
    }
    
    .nav-item {
      display: flex;
      flex-direction: column;
      align-items: center;
      text-decoration: none;
      color: #666;
      font-size: 0.75rem;
      transition: all 0.3s ease;
    }
    
    .nav-item i {
      font-size: 1.5rem;
      margin-bottom: 4px;
    }
    
    .nav-item.active {
      color: var(--primary);
    }
    
    .nav-item:hover {
      color: var(--primary);
      transform: translateY(-3px);
    }
    
    .cart-count {
      position: absolute;
      top: -5px;
      right: -5px;
      background: var(--primary);
      color: white;
      border-radius: 50%;
      width: 18px;
      height: 18px;
      font-size: 0.65rem;
      display: flex;
      align-items: center;
      justify-content: center;
      font-weight: 600;
    }
    
    /* Animations */
    @keyframes float {
      0%, 100% { transform: translateY(0); }
      50% { transform: translateY(-10px); }
    }
    
    .floating {
      animation: float 6s ease-in-out infinite;
    }
    
    /* Responsive Adjustments */
    @media (max-width: 768px) {
      .carousel-item img {
        height: 160px;
      }
      
      .offer-banner {
        margin: 20px 0;
        padding: 15px;
      }
      
      .offer-banner h4 {
        font-size: 1.1rem;
      }
    }
  </style>
</head>
<body>
  <!-- Header -->
 

  <div class="container mt-3">
    <!-- Hero Slider -->
    <div id="offerSlider" class="carousel slide hero-slider" data-bs-ride="carousel">
      <div class="carousel-inner">
        <?php
        $active = true;
        while ($row = $offers->fetch_assoc()): ?>
          <div class="carousel-item <?= $active ? 'active' : '' ?>">
            <img src="<?= $row['image_url'] ?>" class="d-block w-100" alt="Offer">
          </div>
          <?php $active = false; 
        endwhile; 
        
        // If no offers, show default image
        if ($offers->num_rows === 0): ?>
          <div class="carousel-item active">
            <img src="https://images.unsplash.com/photo-1581092921461-39b2f2f99d9a?ixlib=rb-1.2.1&auto=format&fit=crop&w=1350&q=80" class="d-block w-100" alt="Printing Services">
          </div>
        <?php endif; ?>
      </div>
      <button class="carousel-control-prev" type="button" data-bs-target="#offerSlider" data-bs-slide="prev">
        <i class="bi bi-chevron-left text-dark"></i>
      </button>
      <button class="carousel-control-next" type="button" data-bs-target="#offerSlider" data-bs-slide="next">
        <i class="bi bi-chevron-right text-dark"></i>
      </button>
    </div>

    <!-- Categories Grid -->
    <div class="category-grid">
      <!-- Print -->
      <div class="category-card" onclick="location.href='prints.php'">
        <div class="category-img">
          <img src="images/prints.png" alt="Print" class="floating" style="animation-delay: 0.2s">
        </div>
        <div class="category-body">
          <h5 class="category-title">Print</h5>
          <a href="prints.php" class="category-btn">Explore</a>
        </div>
      </div>
      
      <!-- Pad -->
      <div class="category-card" onclick="location.href='pad_list.php'">
        <div class="category-img">
          <img src="images/pad.png" alt="Pad" class="floating" style="animation-delay: 0.4s">
        </div>
        <div class="category-body">
          <h5 class="category-title">Pad</h5>
          <a href="pads.php" class="category-btn">Explore</a>
        </div>
      </div>
      
      <!-- Packages -->
      <div class="category-card" onclick="location.href='preimumprice.php'">
        <div class="category-img">
          <img src="images/acces.png" alt="Packages" class="floating" style="animation-delay: 0.6s">
        </div>
        <div class="category-body">
          <h5 class="category-title">Packages</h5>
          <a href="preimumprice.php" class="category-btn">View All</a>
        </div>
      </div>
      
      <!-- Addons -->
      <div class="category-card" onclick="location.href='others.php'">
        <div class="category-img">
          <img src="images/others.png" alt="Addons" class="floating" style="animation-delay: 0.8s">
        </div>
        <div class="category-body">
          <h5 class="category-title">Addons</h5>
          <a href="others.php" class="category-btn">Explore</a>
        </div>
      </div>
    </div>

    <!-- Special Offer Banner -->
    <div class="offer-banner">
      <h4>🎉 Limited Time Offer 🎉</h4>
      <p>Get 20% OFF on Premium Packages. Hurry, offer ends soon!</p>
      <button class="offer-btn" onclick="location.href='preimumprice.php'">Claim Offer <i class="bi bi-arrow-right ms-1"></i></button>
    </div>
  </div>

  <!-- Bottom Navigation -->
  <nav class="bottom-nav">
    <div class="container">
      <div class="d-flex justify-content-around">
        <!-- Home -->
        <a href="index.php" class="nav-item active">
          <i class="bi bi-house-door"></i>
          <span>Home</span>
        </a>
        
        <!-- Cart -->
        <a href="cart.php" class="nav-item position-relative">
          <i class="bi bi-cart3"></i>
          <span>Cart</span>
          <span class="cart-count" id="cartCount">0</span>
        </a>
        
        <!-- Orders -->
        <a href="orders.php" class="nav-item">
          <i class="bi bi-box-seam"></i>
          <span>Orders</span>
        </a>
        
        <!-- Profile -->
        <a href="profile.php" class="nav-item">
          <i class="bi bi-person"></i>
          <span>Profile</span>
        </a>
      </div>
    </div>
  </nav>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    // Initialize carousel with autoplay
    const offerSlider = new bootstrap.Carousel(document.getElementById('offerSlider'), {
      interval: 3000,
      ride: 'carousel'
    });

    // Update cart count
    function updateCartCount() {
      let cart = JSON.parse(localStorage.getItem('cart')) || [];
      document.getElementById('cartCount').textContent = cart.length;
    }

    // Initialize cart count
    document.addEventListener('DOMContentLoaded', function() {
      updateCartCount();
      
      // Add click effect to category cards
      document.querySelectorAll('.category-card').forEach(card => {
        card.addEventListener('click', function() {
          window.location.href = this.querySelector('a').href;
        });
      });
    });

    // Add animation on scroll
    const observerOptions = {
      threshold: 0.1
    };

    const observer = new IntersectionObserver((entries) => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          entry.target.classList.add('animate__animated', 'animate__fadeInUp');
          observer.unobserve(entry.target);
        }
      });
    }, observerOptions);

    document.querySelectorAll('.category-card, .offer-banner').forEach(el => {
      observer.observe(el);
    });
  </script>
</body>
</html>