<?php
session_start();
include 'header.php';

// Database connection
$host = "localhost";
$db = "savithri";
$user = "savithri";
$pass = "LU*[nrO_70]7zsR_";

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Ensure user is logged in
if (!isset($_SESSION['email'])) {
    die("You must log in first.");
}

$user_email = $_SESSION['email'];

// Fetch user's region
$user_stmt = $conn->prepare("SELECT region FROM users WHERE email = ?");
$user_stmt->bind_param("s", $user_email);
$user_stmt->execute();
$user_res = $user_stmt->get_result();

if ($user_res->num_rows === 0) {
    die("User not found.");
}

$user_data = $user_res->fetch_assoc();
$user_region = strtolower(trim($user_data['region']));

// Select price column based on region
$price_column = ($user_region === "region 2") ? "price_region" : "price";

// Fetch products with correct price column
$result = $conn->query("SELECT id, name, $price_column AS price FROM print_products WHERE category_id = 2");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Konica Minolta Products</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
  <style>
    body {
      background: #f5f5f5;
      font-family: 'Segoe UI', sans-serif;
    }
    .card {
      border-radius: 15px;
      transition: transform 0.2s;
    }
    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }
    .product-title {
      font-weight: 600;
      font-size: 16px;
      color: #2c3169;
    }
    .price-per-page {
      font-size: 14px;
      color: #666;
    }
    .total {
      font-weight: bold;
      color: #2c3169;
      font-size: 1.1rem;
    }
    .btn-icon {
      padding: 4px 12px;
      font-size: 14px;
      border-radius: 5px;
    }
    .page-input {
      width: 60px;
      text-align: center;
      margin: 0 5px;
      border-radius: 5px;
      border: 1px solid #ddd;
      padding: 4px 8px;
    }
    .add-to-cart-btn {
      background-color: #2c3169;
      color: white;
      border: none;
      padding: 6px 15px;
      border-radius: 5px;
      cursor: pointer;
      transition: background-color 0.3s;
    }
    .add-to-cart-btn:hover {
      background-color: #1a1f4b;
    }
    .add-to-cart-btn:disabled {
      background-color: #cccccc;
      cursor: not-allowed;
    }
    .toast {
      position: fixed;
      bottom: 20px;
      right: 20px;
      z-index: 9999;
      min-width: 250px;
    }
  </style>
</head>
<body>

<!-- Toast container for notifications -->
<div id="toastContainer" style="position: fixed; top: 20px; right: 20px; z-index: 9999;"></div>

<div class="container py-5">
  <h2 class="mb-4 text-center" style="color: #2c3169;">Konica Minolta Products</h2>
  <div class="row">
    <?php while ($row = $result->fetch_assoc()): ?>
    <div class="col-md-6 col-lg-4 mb-4">
      <div class="card p-3 shadow-sm h-100">
        <div class="d-flex justify-content-between align-items-center mb-3">
          <span class="product-title"><?= htmlspecialchars($row['name']) ?></span>
          <span id="total-<?= $row['id'] ?>" class="total">₹ 0.00</span>
        </div>
        <div class="d-flex flex-column">
          <small class="price-per-page mb-2">
              <i class="fas fa-tag me-1"></i> ₹<?= number_format($row['price'], 2) ?> per page
          </small>
          <div class="d-flex align-items-center justify-content-between mt-2">
            <div class="d-flex align-items-center">
              <button type="button" class="btn btn-outline-secondary btn-icon" 
                      onclick="changePages(<?= $row['id'] ?>, -1, <?= $row['price'] ?>)">
                <i class="fas fa-minus"></i>
              </button>
              <input type="number" id="pages-<?= $row['id'] ?>" 
                     value="0" min="0" step="1" 
                     class="form-control form-control-sm page-input" 
                     onchange="updateTotal(<?= $row['id'] ?>, <?= $row['price'] ?>)">
              <button type="button" class="btn btn-outline-secondary btn-icon" 
                      onclick="changePages(<?= $row['id'] ?>, 1, <?= $row['price'] ?>)">
                <i class="fas fa-plus"></i>
              </button>
            </div>
            <button id="add-to-cart-<?= $row['id'] ?>" 
                    class="add-to-cart-btn" 
                    onclick="addToCart(<?= $row['id'] ?>, <?= $row['price'] ?>)" 
                    disabled>
              <i class="fas fa-cart-plus me-1"></i> Add
            </button>
          </div>
        </div>
      </div>
    </div>
    <?php endwhile; ?>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Add to cart function
async function addToCart(productId, price) {
    const quantity = parseInt(document.getElementById('pages-' + productId).value) || 0;
    if (quantity <= 0) return;

    try {
        const response = await fetch('update_cart.php', {
            method: 'POST',
            headers: { 
                'Content-Type': 'application/json',
                'X-Requested-With': 'XMLHttpRequest'
            },
            body: JSON.stringify({
                action: 'add',
                product_id: productId,
                product_type: 'print',
                quantity: quantity
            })
        });
        
        const result = await response.json();
        
        if (result.success) {
            // Update cart count
            const cartCount = result.cart_count || 0;
            const cartBadges = document.querySelectorAll('.cart-count');
            cartBadges.forEach(badge => {
                badge.textContent = cartCount;
                badge.style.display = cartCount > 0 ? 'inline-block' : 'none';
            });
            
            // Show success message
            showToast('Product added to cart!', 'success');
            
            // Reset quantity
            document.getElementById('pages-' + productId).value = 0;
            updateTotal(productId, price);
        } else {
            showToast(result.error || 'Failed to add to cart', 'error');
        }
    } catch (error) {
        console.error('Error:', error);
        showToast('Error adding to cart. Please try again.', 'error');
    }
}

// Show toast notification
function showToast(message, type = 'info') {
    const toast = document.createElement('div');
    toast.className = `toast show align-items-center text-white bg-${type === 'error' ? 'danger' : 'success'} border-0`;
    toast.role = 'alert';
    toast.innerHTML = `
        <div class="d-flex">
            <div class="toast-body">
                <i class="fas ${type === 'error' ? 'fa-exclamation-circle' : 'fa-check-circle'} me-2"></i>
                ${message}
            </div>
            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
        </div>
    `;
    
    const container = document.getElementById('toastContainer');
    container.appendChild(toast);
    
    setTimeout(() => toast.remove(), 3000);
}

// Update total price
function updateTotal(id, price) {
    const input = document.getElementById('pages-' + id);
    const totalElement = document.getElementById('total-' + id);
    const addToCartBtn = document.getElementById('add-to-cart-' + id);
    const quantity = parseInt(input.value) || 0;
    
    if (quantity > 0) {
        const total = (quantity * price).toFixed(2);
        totalElement.textContent = '₹ ' + total;
        if (addToCartBtn) addToCartBtn.disabled = false;
    } else {
        totalElement.textContent = '₹ 0.00';
        if (addToCartBtn) addToCartBtn.disabled = true;
    }
}

// Change pages function
function changePages(id, delta, price) {
    const input = document.getElementById('pages-' + id);
    let pages = parseInt(input.value) || 0;
    pages = Math.max(0, pages + delta);
    input.value = pages;
    updateTotal(id, price);
}
</script>

</body>
</html>