<?php
// save_order.php
header('Content-Type: application/json');

session_start();
error_reporting(E_ALL);
ini_set('display_errors', 0);

function sendJsonResponse($data) {
    header('Content-Type: application/json');
    echo json_encode($data);
    exit;
}

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    sendJsonResponse(['success' => false, 'error' => 'User not logged in']);
}

$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($conn->connect_error) {
    sendJsonResponse(['success' => false, 'error' => 'Database connection failed: ' . $conn->connect_error]);
}

try {
    // Start transaction
    $conn->begin_transaction();

    // Generate order number
    $date = date('Ymd');
    $random = str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT);
    $order_number = 'ORD-' . $date . '-' . $random;
    $user_id = $_SESSION['user_id'];

    // Get cart items
    $query = "SELECT c.*, 
                     COALESCE(p.name, pp.name) as product_name,
                     COALESCE(p.price, pp.price) as price
              FROM cart c
              LEFT JOIN products p ON (c.product_id = p.id AND c.product_type = 'regular')
              LEFT JOIN print_products pp ON (c.product_id = pp.id AND c.product_type = 'print')
              WHERE c.user_id = ?";
    
    $stmt = $conn->prepare($query);
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }
    
    $stmt->bind_param('i', $user_id);
    if (!$stmt->execute()) {
        throw new Exception("Execute failed: " . $stmt->error);
    }
    
    $result = $stmt->get_result();
    $cart_items = $result->fetch_all(MYSQLI_ASSOC);

    if (empty($cart_items)) {
        throw new Exception("Your cart is empty");
    }

    // Calculate total
    $total = 0;
    foreach ($cart_items as $item) {
        $total += $item['price'] * $item['quantity'];
    }

    // Save order to database
    $status = 'pending';
    $stmt = $conn->prepare("INSERT INTO orders (order_number, user_id, total, status) VALUES (?, ?, ?, ?)");
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }
    
    $stmt->bind_param('sids', $order_number, $user_id, $total, $status);
    if (!$stmt->execute()) {
        throw new Exception("Execute failed: " . $stmt->error);
    }
    
    $order_id = $conn->insert_id;

    // Save order items
    $stmt = $conn->prepare("INSERT INTO order_items (order_id, product_id, product_type, quantity, price) VALUES (?, ?, ?, ?, ?)");
    if (!$stmt) {
        throw new Exception("Prepare failed: " . $conn->error);
    }

    foreach ($cart_items as $item) {
        $stmt->bind_param('iisid', 
            $order_id, 
            $item['product_id'], 
            $item['product_type'], 
            $item['quantity'], 
            $item['price']
        );
        if (!$stmt->execute()) {
            throw new Exception("Failed to save order item: " . $stmt->error);
        }
    }

    // Clear cart after successful order
    $stmt = $conn->prepare("DELETE FROM cart WHERE user_id = ?");
    $stmt->bind_param('i', $user_id);
    if (!$stmt->execute()) {
        throw new Exception("Failed to clear cart: " . $stmt->error);
    }

    // If we got here, everything is good
    $conn->commit();
    sendJsonResponse([
        'success' => true, 
        'order_number' => $order_number,
        'order_id' => $order_id
    ]);

} catch (Exception $e) {
    $conn->rollback();
    sendJsonResponse([
        'success' => false, 
        'error' => $e->getMessage()
    ]);
} finally {
    $conn->close();
}
?>