// Login Form Submission
document.getElementById("loginForm").addEventListener("submit", function(e) {
  e.preventDefault();
  var username = document.getElementById("username").value;
  var password = document.getElementById("password").value;

  if(username === "admin" && password === "12345") {
    window.location.href = "categories.html";
  } else {
    alert("Invalid username or password. Please try again.");
  }
});
function openProducts(category) {
  window.location.href = "products.html?category=" + category;
}

function openCartPopup() {
  alert("Cart popup will open here soon!");
}
const productsData = {
  mixing: {
    title: "Mixing Pack",
    products: [
      {
        name: "MP 85 / 11.5",
        details: ["Transparent - 1", "Glitter - 1", "Metallic - 2", "Hologram - 2", "Feather - 1", "Texture - 2", "Silky Mate - 2", "Emboss - 1/2"],
        price: 820
      },
      {
        name: "MP 55 / 11.5",
        details: ["Metallic - 2", "Hologram - 2", "Feather - 2", "Texture - 2", "Silky Mate - 2", "Emboss - 1/2"],
        price: 550
      },
      {
        name: "MP 60 / 11",
        details: ["Transparent - 1", "Glitter - 1", "Metallic - 2", "Hologram - 2", "Feather - 1", "Texture - 2", "Silky Mate - 2"],
        price: 570
      }
    ]
  },
  basicnp: {
    title: "Basic Package - NP , EBB",
    products: [
      {
        name: "7 color print by HP Indigo",
        details: ["30 sheets glossy album with rexin pad & bag", "Normal pad & bag", "3 sheet calendar"],
        price: 3010
      },
      {
        name: "RGB print by Konica Minolta",
        details: ["30 sheets glossy album with rexin pad & bag", "Normal pad & bag", "3 sheet calendar"],
        price: 2560
      }
    ]
  },
  delight: {
    title: "Basic Package - Delight",
    products: [
      {
        name: "7 color print by HP Indigo",
        details: ["30 sheets glossy album with semi rexin delight pad & bag", "3 sheet calendar"],
        price: 3110
      },
      {
        name: "RGB print by Konica Minolta",
        details: ["30 sheets glossy album with semi rexin delight pad & bag", "3 sheet calendar"],
        price: 2660
      }
    ]
  }
};

const urlParams = new URLSearchParams(window.location.search);
const category = urlParams.get('category');
const categoryData = productsData[category];

if (categoryData) {
  document.getElementById('categoryTitle').innerText = categoryData.title;
  const productsList = document.getElementById('productsList');

  categoryData.products.forEach((product, index) => {
    const productCard = document.createElement('div');
    productCard.className = 'product-card';
    productCard.innerHTML = `
      <h3>${product.name}</h3>
      <ul>${product.details.map(detail => `<li>${detail}</li>`).join('')}</ul>
      <p class="price">₹${product.price}</p>
      <button onclick="addToCart('${categoryData.title}', '${product.name}', ${product.price})">Add to Cart</button>
    `;
    productsList.appendChild(productCard);
  });
}

let cart = [];

function addToCart(category, name, price) {
  cart.push({category, name, price});
  document.getElementById('cartCount').innerText = cart.length;
  openCartPopup();
  updateCartPopup();
}

function openCartPopup() {
  document.getElementById('cartPopup').style.display = 'flex';
}

function closeCartPopup() {
  document.getElementById('cartPopup').style.display = 'none';
}

function updateCartPopup() {
  const cartItems = document.getElementById('cartItems');
  const totalPrice = document.getElementById('totalPrice');
  cartItems.innerHTML = '';
  let total = 0;

  cart.forEach(item => {
    const li = document.createElement('li');
    li.innerText = `${item.category} - ${item.name} : ₹${item.price}`;
    cartItems.appendChild(li);
    total += item.price;
  });

  totalPrice.innerText = `Total: ₹${total}`;
}

function downloadCart() {
  const { jsPDF } = window.jspdf;
  const doc = new jsPDF();

  doc.text("Savithri Digital Print Press - Cart Details", 10, 10);

  cart.forEach((item, index) => {
    doc.text(`${index + 1}. ${item.category} - ${item.name} - ₹${item.price}`, 10, 20 + (index * 10));
  });

  doc.save("CartDetails.pdf");
}
