<?php
session_start();
header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'error' => 'Please log in to add items to cart']);
    exit;
}

// Get and validate input
$input = json_decode(file_get_contents('php://input'), true);
if (json_last_error() !== JSON_ERROR_NONE) {
    echo json_encode(['success' => false, 'error' => 'Invalid input']);
    exit;
}

$product_id = isset($input['product_id']) ? (int)$input['product_id'] : 0;
$quantity = isset($input['quantity']) ? (int)$input['quantity'] : 1;
$product_name = $input['name'] ?? '';
$price = isset($input['price']) ? (float)$input['price'] : 0;
$pad_type_id = isset($input['pad_type_id']) ? (int)$input['pad_type_id'] : 0;
$pad_type_name = $input['pad_type_name'] ?? '';

// Validate input
if ($product_id <= 0 || empty($product_name) || $price <= 0 || $pad_type_id <= 0) {
    echo json_encode(['success' => false, 'error' => 'Invalid product details']);
    exit;
}

// Database connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

// Check if this pad product is already in the cart for this user and pad type
$check = $conn->prepare("
    SELECT id, quantity 
    FROM cart 
    WHERE user_id = ? AND product_id = ? AND product_type = 'pad' AND pad_type_id = ?
");
$check->bind_param("iii", $_SESSION['user_id'], $product_id, $pad_type_id);
$check->execute();
$result = $check->get_result();

if ($result->num_rows > 0) {
    // Update quantity if product already in cart
    $item = $result->fetch_assoc();
    $new_quantity = $item['quantity'] + $quantity;
    
    $update = $conn->prepare("
        UPDATE cart 
        SET quantity = ?, updated_at = NOW() 
        WHERE id = ?
    ");
    $update->bind_param("ii", $new_quantity, $item['id']);
    $success = $update->execute();
} else {
    // Insert new item
    $insert = $conn->prepare("
        INSERT INTO cart 
        (user_id, product_id, quantity, product_type, product_name, price, 
         pad_type_id, pad_type_name, created_at, updated_at) 
        VALUES (?, ?, ?, 'pad', ?, ?, ?, ?, NOW(), NOW())
    ");
    $insert->bind_param(
        "iiisdis", 
        $_SESSION['user_id'], 
        $product_id, 
        $quantity, 
        $product_name, 
        $price,
        $pad_type_id,
        $pad_type_name
    );
    $success = $insert->execute();
}

// Get updated cart count
$count_result = $conn->query("
    SELECT COALESCE(SUM(quantity), 0) as count 
    FROM cart 
    WHERE user_id = " . $_SESSION['user_id']
);
$count = $count_result ? (int)$count_result->fetch_assoc()['count'] : 0;

$conn->close();

echo json_encode([
    'success' => $success,
    'cart_count' => $count
]);