<?php
session_start();
header('Content-Type: application/json');

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'error' => 'Please login to add items to cart']);
    exit;
}

// Get POST data
$input = json_decode(file_get_contents('php://input'), true);
$product_id = isset($input['product_id']) ? (int)$input['product_id'] : 0;
$quantity = isset($input['quantity']) ? (int)$input['quantity'] : 1;

if ($product_id <= 0) {
    echo json_encode(['success' => false, 'error' => 'Invalid product']);
    exit;
}

// Database connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed: ' . $conn->connect_error]);
    exit;
}

// Check if product exists
$stmt = $conn->prepare("SELECT id, name, price FROM products WHERE id = ?");
$stmt->bind_param("i", $product_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo json_encode(['success' => false, 'error' => 'Product not found']);
    $conn->close();
    exit;
}

$product = $result->fetch_assoc();
$product_type = 'product';
$product_name = $product['name'];
$price = $product['price'];
$user_id = $_SESSION['user_id'];

// Add to cart
$stmt = $conn->prepare("
    INSERT INTO cart (user_id, product_id, quantity, product_type, product_name, price)
    VALUES (?, ?, ?, ?, ?, ?)
    ON DUPLICATE KEY UPDATE quantity = quantity + VALUES(quantity)
");
$stmt->bind_param("iiissd", $user_id, $product_id, $quantity, $product_type, $product_name, $price);

if ($stmt->execute()) {
    $countResult = $conn->query("SELECT SUM(quantity) AS count FROM cart WHERE user_id = $user_id");
    $count = $countResult->fetch_assoc()['count'] ?? 0;
    echo json_encode(['success' => true, 'cart_count' => (int)$count]);
} else {
    echo json_encode([
        'success' => false,
        'error' => 'Failed to add to cart: ' . $stmt->error
    ]);
}

$stmt->close();
$conn->close();
?>
