<?php include 'includes/header.php'; ?>
<?php
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

$id = intval($_GET['id']); // prevent SQL injection
$user = $conn->query("SELECT * FROM users WHERE id = $id")->fetch_assoc();

// Check if password is already set (assuming you store hashed passwords in `password` column)
$hasPassword = !empty($user['password']);
$hasRegion   = !empty($user['region']);

// If both region and password are set, disable button & radios
$isLocked = $hasPassword && $hasRegion;
?>

<div class="container mt-5">
    <h2 class="mb-4">👤 User Details</h2>

    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <table class="table table-bordered table-striped mb-0">
                <tbody>
                    <tr>
                        <th style="width: 200px;">Name</th>
                        <td><?= htmlspecialchars($user['name']) ?></td>
                    </tr>
                    <tr>
                        <th>Email</th>
                        <td><?= htmlspecialchars($user['email']) ?></td>
                    </tr>
                    <tr>
                        <th>Mobile</th>
                        <td><?= htmlspecialchars($user['mobile']) ?></td>
                    </tr>
                    <tr>
                        <th>Address</th>
                        <td><?= htmlspecialchars($user['address']) ?></td>
                    </tr>
                     <tr><th>Zip Code</th><td><?= htmlspecialchars($user['zip_code']) ?></td></tr>
        <tr><th>State</th><td><?= htmlspecialchars($user['state']) ?></td></tr>
                </tbody>
            </table>
        </div>
    </div>

   <form id="sendPasswordForm" method="POST" action="send_password_link.php" class="card p-3 shadow-sm">
    <input type="hidden" name="id" value="<?= $id ?>">

    <h5 class="mb-3">Select Region</h5>

    <!-- Region 1 -->
    <div class="form-check mb-2">
        <input class="form-check-input" type="radio" name="region" id="region1" value="Region 1"
            <?= ($user['region'] == 'Region 1') ? 'checked' : '' ?>
            <?= ($isLocked && $user['region'] != 'Region 1') ? 'disabled' : '' ?>
            required>
        <label class="form-check-label fw-bold <?= ($user['region'] == 'Region 1') ? 'text-success' : '' ?>" for="region1">
            Region 1
        </label>
    </div>

    <!-- Region 2 -->
    <div class="form-check mb-3">
        <input class="form-check-input" type="radio" name="region" id="region2" value="Region 2"
            <?= ($user['region'] == 'Region 2') ? 'checked' : '' ?>
            <?= ($isLocked && $user['region'] != 'Region 2') ? 'disabled' : '' ?>>
        <label class="form-check-label fw-bold <?= ($user['region'] == 'Region 2') ? 'text-success' : '' ?>" for="region2">
            Region 2
        </label>
    </div>

    <button type="submit" class="btn btn-success" <?= $isLocked ? 'disabled' : '' ?>>
        Send Password Setup Link
    </button>
</form>

<!-- SweetAlert2 for popup -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.getElementById('sendPasswordForm').addEventListener('submit', function(e) {
    e.preventDefault(); // stop normal form submit

    const form = this;
    const formData = new FormData(form);

    // Disable button while sending
    const btn = form.querySelector('button[type="submit"]');
    btn.disabled = true;
    btn.innerText = 'Sending...';

    fetch(form.action, {
        method: 'POST',
        body: formData
    })
    .then(res => res.text())
    .then(data => {
        Swal.fire({
            icon: data.toLowerCase().includes('success') ? 'success' : 'error',
            title: data.toLowerCase().includes('success') ? 'Link Sent!' : 'Error',
            text: data,
            confirmButtonColor: '#198754'
        });
    })
    .catch(err => {
        Swal.fire({
            icon: 'error',
            title: 'Error',
            text: 'Something went wrong: ' + err
        });
    })
    .finally(() => {
        btn.disabled = false;
        btn.innerText = 'Send Password Setup Link';
    });
});
</script>

</div>

<?php include 'includes/footer.php'; ?>
