<?php include 'includes/header.php'; ?>

<?php
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
$result = $conn->query("SELECT o.order_number, o.created_at, i.name, i.pages, i.price, i.total 
                        FROM orders o 
                        JOIN order_items i ON o.id = i.order_id 
                        ORDER BY o.created_at DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>View Orders</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background-color: #f9f9f9;
      font-family: 'Segoe UI', sans-serif;
    }
    .table thead {
      background-color: #0d6efd;
      color: #fff;
    }
    .card {
      border-radius: 15px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.08);
    }
    h2 {
      color: #333;
    }
  </style>
</head>
<body>
<div class="container mt-5">
  <div class="card p-4">
    <h2 class="mb-4 text-center">🧾 All Orders</h2>

    <div class="table-responsive">
      <table class="table table-hover table-bordered align-middle">
        <thead class="text-center">
          <tr>
            <th>#</th>
            <th>Order Number</th>
            <th>Date</th>
            <th>Product Name</th>
            <th>Pages</th>
            <th>Price (₹)</th>
            <th>Total (₹)</th>
          </tr>
        </thead>
        <tbody>
          <?php 
          $count = 1;
          while ($row = $result->fetch_assoc()): ?>
            <tr>
              <td class="text-center"><?= $count++ ?></td>
              <td><?= $row['order_number'] ?></td>
              <td><?= date('d-m-Y h:i A', strtotime($row['created_at'])) ?></td>
              <td><?= htmlspecialchars($row['name']) ?></td>
              <td class="text-center"><?= $row['pages'] ?></td>
              <td class="text-end">₹<?= number_format($row['price'], 2) ?></td>
              <td class="text-end fw-bold text-success">₹<?= number_format($row['total'], 2) ?></td>
            </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
</body>
</html>
