<?php
session_start();
header('Content-Type: application/json');



// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'error' => 'User not logged in']);
    exit;
}

// Read JSON input
$input = json_decode(file_get_contents('php://input'), true);
$product_id = isset($input['product_id']) ? (int)$input['product_id'] : 0;
$quantity   = isset($input['quantity']) ? (int)$input['quantity'] : 1;
$product_type = isset($input['product_type']) ? $input['product_type'] : 'product';

if ($product_id <= 0) {
    echo json_encode(['success' => false, 'error' => 'Invalid product ID']);
    exit;
}

// Connect to DB
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'DB connection failed: ' . $conn->connect_error]);
    exit;
}

$user_id = (int)$_SESSION['user_id'];

// Check product existence
$stmt = $conn->prepare("SELECT id, name, price FROM products WHERE id = ?");
$stmt->bind_param("i", $product_id);
$stmt->execute();
$product = $stmt->get_result()->fetch_assoc();

if (!$product) {
    echo json_encode(['success' => false, 'error' => 'Product not found in DB']);
    exit;
}

// Insert or update cart
$stmt = $conn->prepare("
    INSERT INTO cart (user_id, product_id, quantity, product_type, product_name, price, updated_at)
    VALUES (?, ?, ?, ?, ?, ?, NOW())
    ON DUPLICATE KEY UPDATE quantity = quantity + VALUES(quantity), updated_at = NOW()
");

$stmt->bind_param(
    "iiissd",
    $user_id,
    $product['id'],
    $quantity,
    $product_type,
    $product['name'],
    $product['price']
);

if ($stmt->execute()) {
    // Get total count
    $res = $conn->query("SELECT COALESCE(SUM(quantity),0) AS total FROM cart WHERE user_id = $user_id");
    $count = $res->fetch_assoc()['total'] ?? 0;
    echo json_encode(['success' => true, 'cart_count' => (int)$count]);
} else {
    echo json_encode(['success' => false, 'error' => 'MySQL error: ' . $conn->error]);
}

$stmt->close();
$conn->close();
?>
