<?php
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $company_name   = trim($_POST['company_name']);
    $billing_address = trim($_POST['billing_address']);
    $gst_no         = trim($_POST['gst_no']);
    $name           = trim($_POST['name']);
    $mobile         = trim($_POST['mobile']);
    $email          = trim($_POST['email']);
    $address        = trim($_POST['address']);
    $zip_code       = trim($_POST['zip_code']);
    $state          = trim($_POST['state']);

    // Check if email exists
    $check_sql = "SELECT * FROM users WHERE email = ?";
    $stmt = $conn->prepare($check_sql);
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        echo "<script>alert('This email is already registered.'); window.location='register.php';</script>";
    } else {
        $sql = "INSERT INTO users (company_name, billing_address, gst_no, name, mobile, email, address, zip_code, state)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssssssss", $company_name, $billing_address, $gst_no, $name, $mobile, $email, $address, $zip_code, $state);
        if ($stmt->execute()) {
            echo "<script>alert('Registration successful! Admin will create your username soon.'); window.location='index.php';</script>";
        } else {
            echo "<script>alert('Error: " . $stmt->error . "');</script>";
        }
    }
    $stmt->close();
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>User Registration | Savithri Digital Print Press</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="icon" href="https://test.kalpavrukshaits.com/savithridigital/images/logo.jpeg" type="image/png">
    <!-- Bootstrap 5 CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- Bootstrap Icons -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <style>
        .header {
  background: rgba(255, 255, 255, 0.98);
  box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08);
  position: fixed;
  width: 100%;
  z-index: 1000;
  padding: 12px 6%;
  display: flex;
  justify-content: space-between;
  align-items: center;
  top: 0;
  left: 0;
}

/* LOGO + TAGLINE vertically aligned */
.logo-container {
  display: flex;
  flex-direction: column;
  align-items: flex-start;
}

.logo {
  height: 60px;
  width: auto;
  margin-bottom: 5px;
  transition: transform 0.3s ease;
}

.logo:hover {
  transform: scale(1.05);
}

.tagline {
  font-size: 14px;
  font-weight: 600;
  color: #2F2F4F;
  font-style: italic;
  letter-spacing: 0.6px;
  margin: 0;
}

/* NAV BUTTONS */
.nav-buttons {
  display: flex;
  align-items: center;
  gap: 15px;
}

.btn {
  padding: 8px 22px;
  border-radius: 25px;
  font-weight: 600;
  text-decoration: none;
  transition: all 0.3s ease;
  display: inline-flex;
  align-items: center;
  justify-content: center;
}

/* LOGIN BUTTON */
.btn-login {
  background: #fff;
  border: 2px solid #2f2a85;
  color: #2f2a85;
}

.btn-login:hover {
  background: #2f2a85;
  color: white;
}

/* REGISTER BUTTON */
.btn-register {
  background: #2f2a85;
  color: white;
}

.btn-register:hover {
  background: #221c6a;
}

/* ---------- MOBILE VIEW ---------- */
@media (max-width: 768px) {
  .header {
    flex-direction: row;
    align-items: flex-start;
    justify-content: space-between;
    padding: 10px 20px;
  }

  .logo-container {
    align-items: flex-start;
  }

  .nav-buttons {
    flex-direction: column;
    gap: 8px;
  }

  .logo {
    height: 50px;
  }

  .tagline {
    font-size: 13px;
  }

  .btn {
    padding: 6px 16px;
    font-size: 13px;
  }
}



    </style>
</head>
<body>

<header class="header">
  <div class="logo-container">
    <img src="https://test.kalpavrukshaits.com/savithridigital/images/logo.jpeg" 
         alt="Savithri Digital Logo" class="logo">
    <p class="tagline">We Exceed Your Expectations</p>
  </div>

  <div class="nav-buttons">
    <a href="https://test.kalpavrukshaits.com/savithridigital/admin/signin.php" class="btn btn-login">
      <i class="bi bi-box-arrow-in-right"></i> Login
    </a>
    <a href="https://test.kalpavrukshaits.com/savithridigital/register.php" class="btn btn-register">
      <i class="bi bi-person-plus"></i> Register
    </a>
  </div>
</header>

<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-7 col-lg-6">
            <div class="card shadow p-4" style="
    margin-top: 123px;
">
                <h3 class="text-center mb-4 fw-bold" style="color: var(--main-color);">User Registration</h3>

                <form method="POST">
                    <div class="mb-3">
                        <label class="form-label">Company Name</label>
                        <input type="text" name="company_name" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Billing Address</label>
                        <textarea name="billing_address" class="form-control" rows="2" required></textarea>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">GST Number</label>
                        <input type="text" name="gst_no" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Name</label>
                        <input type="text" name="name" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Mobile Number</label>
                        <input type="text" name="mobile" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>

                   

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Zip Code</label>
                            <input type="text" name="zip_code" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">State</label>
                            <input type="text" name="state" class="form-control" required>
                        </div>
                    </div>

                    <div class="d-grid">
                        <button type="submit" class="btn-submit">Register</button>
                    </div>
                </form>

                <div class="mt-3 text-center">
                    <a href="index.php" class="text-decoration-none fw-semibold" style="color: var(--main-color);">← Back to Home</a>
                </div>
            </div>
        </div>
    </div>
</div>

</body>
</html>
