<?php
// add_to_cart.php
session_start();
header('Content-Type: application/json');

// require DB credentials or include db.php
// Replace these with your actual DB include if you have db.php
$DB_HOST = 'localhost';
$DB_USER = 'savithri';
$DB_PASS = 'LU*[nrO_70]7zsR_';
$DB_NAME = 'savithri';

$conn = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);
if ($conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'DB connection failed']);
    exit;
}

$user_id = isset($_SESSION['user_id']) ? (int)$_SESSION['user_id'] : 0;
if (!$user_id) {
    echo json_encode(['success' => false, 'error' => 'Not logged in']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$product_id = isset($input['product_id']) ? (int)$input['product_id'] : 0;
$quantity = isset($input['quantity']) ? (int)$input['quantity'] : 1;
if ($quantity < 1) $quantity = 1;

if (!$product_id) {
    echo json_encode(['success' => false, 'error' => 'Invalid product id']);
    exit;
}

// use prepared statements: check if already exists
$stmt = $conn->prepare("SELECT quantity FROM user_cart WHERE user_id = ? AND product_id = ?");
if (!$stmt) {
    echo json_encode(['success' => false, 'error' => 'Prepare failed']);
    exit;
}
$stmt->bind_param("ii", $user_id, $product_id);
$stmt->execute();
$res = $stmt->get_result();

if ($res && $res->num_rows > 0) {
    // update existing (increment)
    $stmt_upd = $conn->prepare("UPDATE user_cart SET quantity = quantity + ? WHERE user_id = ? AND product_id = ?");
    $stmt_upd->bind_param("iii", $quantity, $user_id, $product_id);
    $stmt_upd->execute();
    $stmt_upd->close();
} else {
    // insert new row
    $stmt_ins = $conn->prepare("INSERT INTO user_cart (user_id, product_id, quantity) VALUES (?, ?, ?)");
    $stmt_ins->bind_param("iii", $user_id, $product_id, $quantity);
    $stmt_ins->execute();
    $stmt_ins->close();
}
$stmt->close();

// get updated count
$countRes = $conn->query("SELECT SUM(quantity) AS total FROM user_cart WHERE user_id = " . intval($user_id));
$total = 0;
if ($countRes) {
    $row = $countRes->fetch_assoc();
    $total = isset($row['total']) ? (int)$row['total'] : 0;
}

// return JSON
echo json_encode(['success' => true, 'cart_count' => $total]);
$conn->close();
