<?php
session_start();
header('Content-Type: application/json');

// DB connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($conn->connect_error) {
    exit(json_encode(['success' => false, 'error' => 'DB connection failed']));
}

// Decode input
$input = json_decode(file_get_contents('php://input'), true);
if (!$input || !isset($input['items'])) {
    exit(json_encode(['success' => false, 'error' => 'Invalid input']));
}

$items = $input['items'];
$orderNumber = 'ORD'.time();

// ✅ Fetch user name by session email
$userName = "Unknown User";
if (isset($_SESSION['email'])) {
    $email = $conn->real_escape_string($_SESSION['email']);
    $userRes = $conn->query("SELECT name FROM users WHERE email='$email' LIMIT 1");
    if ($userRes && $userRes->num_rows > 0) {
        $row = $userRes->fetch_assoc();
        $userName = $row['name'];
    }
}

// ✅ Insert into orders with user name
$stmt = $conn->prepare("INSERT INTO orders (order_number, user_name, created_at) VALUES (?, ?, NOW())");
$stmt->bind_param("ss", $orderNumber, $userName);
$stmt->execute();
$orderId = $stmt->insert_id;

// Insert order items
$stmtItem = $conn->prepare("INSERT INTO order_items (order_id, name, pages, price, total) VALUES (?, ?, ?, ?, ?)");
foreach ($items as $item) {
    $name  = $item['name'] ?? ($item['product_name'] ?? '');
    $pages = intval($item['pages'] ?? 1);
    $price = floatval($item['price'] ?? $item['mrp'] ?? 0);
    $total = floatval($item['total'] ?? ($price * $pages));
    $stmtItem->bind_param("isidd", $orderId, $name, $pages, $price, $total);
    $stmtItem->execute();
}

// ✅ Return both order number & user name
echo json_encode([
    'success' => true,
    'order_number' => $orderNumber,
    'user_name' => $userName
]);
?>
