<div class="container mt-5">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="bi bi-journal-check"></i> Order Management</h2>
  </div>

  <div class="table-responsive shadow rounded">
    <table class="table table-hover table-bordered bg-white">
      <thead class="table-dark">
        <tr>
          <th>#</th>
          <th>Order No</th>
          <th>Status</th>
          <th>Date & Time</th>
          <th>Action</th>
        </tr>
      </thead>
      <tbody>
        <?php 
        $i = 1;
        while ($row = $orders->fetch_assoc()): ?>
        <tr>
          <td><?= $i++ ?></td>
          <td><strong>#<?= htmlspecialchars($row['order_number']) ?></strong></td>
          <td>
            <span class="badge bg-<?= $row['status'] === 'Completed' ? 'success' : 'warning' ?>">
              <?= $row['status'] ?>
            </span>
          </td>
          <td><?= date('d M Y, h:i A', strtotime($row['created_at'])) ?></td>
          <td>
            <a href="order_details.php?order_number=<?= $row['order_number'] ?>" class="btn btn-outline-primary btn-sm">
              <i class="bi bi-eye"></i> View
            </a>
          </td>
        </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>
