<?php include 'includes/header.php'; ?>
<?php
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");

// Fetch packages
$categories = $conn->query("SELECT * FROM packages");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $package_id = $_POST['category_id'];
  $name = $_POST['name'];
  $description = $_POST['description'];
  $mrp = $_POST['mrp'];
  $selling_price = $_POST['selling_price'] ?? null;

  if ($selling_price === "") {
    $selling_price = null;
  }

  $image = '';
  if (!empty($_FILES['image']['name'])) {
    $image = time() . '_' . basename($_FILES['image']['name']);
    move_uploaded_file($_FILES['image']['tmp_name'], "uploads/" . $image);
  }

  $stmt = $conn->prepare("INSERT INTO products (package_id, name, description, mrp, selling_price, image) VALUES (?, ?, ?, ?, ?, ?)");
  $stmt->bind_param("issdds", $package_id, $name, $description, $mrp, $selling_price, $image);
  $stmt->execute();

  header("Location: products.php?package_id=$package_id");
  exit;
}
?>

<?php include 'header.php'; ?>
<!DOCTYPE html>
<html>
<head>
  <title>Add Product</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    body {
      background: #f9f9f9;
      font-family: 'Segoe UI', sans-serif;
    }
    .form-wrapper {
      background: #fff;
      border-radius: 15px;
      padding: 30px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    h2 {
      font-weight: 600;
      margin-bottom: 25px;
    }
  </style>
</head>
<body>

<div class="container py-5">
  <div class="col-md-8 mx-auto form-wrapper">
    <h2 class="text-center">➕ Add New Product</h2>
    <form method="POST" enctype="multipart/form-data">

      <div class="mb-3">
        <label class="form-label">Select Package</label>
        <select name="category_id" class="form-select" required>
          <option value="">-- Choose a Package --</option>
          <?php while($cat = $categories->fetch_assoc()): ?>
            <option value="<?= $cat['id'] ?>"><?= htmlspecialchars($cat['name']) ?></option>
          <?php endwhile; ?>
        </select>
      </div>

      <div class="mb-3">
        <label class="form-label">Product Name</label>
        <input type="text" name="name" class="form-control" placeholder="Enter product name" required>
      </div>

      <div class="mb-3">
        <label class="form-label">Description</label>
        <textarea name="description" class="form-control" rows="3" placeholder="Enter a short description..."></textarea>
      </div>

      <div class="row mb-3">
        <div class="col-md-6">
          <label class="form-label">MRP (₹)</label>
          <input type="number" step="0.01" name="mrp" class="form-control" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Selling Price (₹) <small class="text-muted">(Optional)</small></label>
          <input type="number" step="0.01" name="selling_price" class="form-control">
        </div>
      </div>

      <div class="mb-4">
        <label class="form-label">Upload Image</label>
        <input type="file" name="image" class="form-control">
      </div>

      <div class="text-center">
        <button class="btn btn-primary px-5">Add Product</button>
      </div>

    </form>
  </div>
</div>

</body>
</html>
