<?php
// Start session and enable error reporting at the very top
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include header
$root = rtrim($_SERVER['DOCUMENT_ROOT'], '/') . '/savithridigital/';
if (file_exists($root . 'header.php')) {
    include $root . 'header.php';
} else {
    // Fallback header if header.php is not found
    echo '<!DOCTYPE html><html><head><title>Cart - Savithri Digital</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        .cart-container { max-width: 1200px; margin: 30px auto; padding: 20px; }
        .cart-item { background: white; border-radius: 10px; padding: 20px; margin-bottom: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.05); }
        .product-image { width: 100px; height: 100px; object-fit: cover; border-radius: 8px; }
        .quantity-input { width: 60px; text-align: center; }
        .empty-cart { text-align: center; padding: 50px 20px; }
        .empty-cart i { font-size: 50px; color: #ddd; margin-bottom: 20px; }
        .pad-list-group { border: 1px solid #dee2e6; border-radius: 8px; margin-bottom: 20px; overflow: hidden; }
        .pad-list-header { background-color: #f8f9fa; padding: 10px 15px; border-bottom: 1px solid #dee2e6; }
    </style>
    </head><body>';
}

// Database connection
$conn = new mysqli("localhost", "savithri", "LU*[nrO_70]7zsR_", "savithri");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$user_id = $_SESSION['user_id'] ?? 0;
if (!$user_id) {
    echo "<div class='empty-cart'><p>Please log in to view your cart.</p></div>";
    if (file_exists($root . 'footer.php')) {
        include $root . 'footer.php';
    } else {
        echo '</body></html>';
    }
    exit;
}

// Updated query to handle pad lists
// ... [Previous code remains the same until the query] ...

// Updated query to handle pad types instead of pad lists
$query = "
    -- Regular and print products
    SELECT 
        c.id as cart_id, 
        c.quantity, 
        c.product_id, 
        c.product_type,
        COALESCE(p.name, pp.name, c.product_name) as name,  -- Added c.product_name as fallback
        CASE 
            WHEN c.product_type = 'print' THEN 
                CASE 
                    WHEN ? = 'region2' THEN pp.price_region 
                    ELSE pp.price 
                END
            WHEN c.product_type = 'regular' THEN p.mrp 
            ELSE c.price  -- Use the price directly from cart for pad items
        END as price,
        COALESCE(p.image, '') as image,
        COALESCE(pkg.name, '') as package_name,
        c.added_date as sort_date,
        c.pad_type_id,
        pt.name as pad_type_name
    FROM cart c
    LEFT JOIN products p ON (c.product_id = p.id AND c.product_type = 'regular')
    LEFT JOIN print_products pp ON (c.product_id = pp.id AND c.product_type = 'print')
    LEFT JOIN packages pkg ON p.package_id = pkg.id
    LEFT JOIN pad_types pt ON c.pad_type_id = pt.id
    WHERE c.user_id = ?
    ORDER BY 
        CASE WHEN c.pad_type_id IS NULL THEN 0 ELSE 1 END,  -- Non-pad items first
        c.pad_type_id,  -- Group pad items by their type
        c.added_date DESC
";

// Rest of the code remains the same...

// Prepare and execute the statement with parameters
$stmt = $conn->prepare($query);
if ($stmt === false) {
    die("Prepare failed: " . $conn->error);
}

$region = ($_SESSION['user_region'] ?? 'Region 1') === 'Region 2' ? 'region2' : 'region1';
$stmt->bind_param('si', $region, $user_id);  // Changed from 'sii' to 'si' since we only have 2 parameters now

if (!$stmt->execute()) {
    die("Execute failed: " . $stmt->error);
}

$result = $stmt->get_result();
$cart_items = $result->fetch_all(MYSQLI_ASSOC);

// Group items
$regular_items = [];
$pad_items = [];

foreach ($cart_items as $item) {
    if ($item['product_type'] === 'pad' && $item['pad_type_id']) {
        $pad_type_id = $item['pad_type_id'];
        if (!isset($pad_items[$pad_type_id])) {
            $pad_items[$pad_type_id] = [
                'type_name' => $item['pad_type_name'] ?? 'Pad Items',
                'items' => []
            ];
        }
        $pad_items[$pad_type_id]['items'][] = $item;
    } else {
        $regular_items[] = $item;
    }
}

// Calculate subtotal
$subtotal = 0;
foreach ($cart_items as $item) {
    $subtotal += $item['price'] * $item['quantity'];
}
?>

<div class="cart-container">
    <h2 class="mb-4">Your Shopping Cart</h2>
    
    <?php if (empty($regular_items) && empty($pad_items)): ?>
        <div class="empty-cart">
            <i class="fas fa-shopping-cart"></i>
            <h3>Your cart is empty</h3>
            <p>Looks like you haven't added anything to your cart yet.</p>
            <a href="products.php" class="btn btn-primary">Continue Shopping</a>
        </div>
    <?php else: ?>
        <div class="row">
            <div class="col-lg-8">
                <!-- Regular Items -->
                <?php foreach ($regular_items as $item): 
                    $item_total = $item['price'] * $item['quantity'];
                ?>
                    <div class="cart-item">
                        <div class="row align-items-center">
                            <div class="col-md-2">
                                <?php if (!empty($item['image'])): ?>
                                    <img src="uploads/<?= htmlspecialchars($item['image']) ?>" 
                                         alt="<?= htmlspecialchars($item['name']) ?>" 
                                         class="product-image">
                                <?php else: ?>
                                    <div class="bg-light d-flex align-items-center justify-content-center" 
                                         style="width: 100px; height: 100px; border-radius: 8px;">
                                        <i class="fas fa-image text-muted"></i>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="col-md-4">
                                <h5 class="mb-1">
                                    <?= htmlspecialchars($item['name']) ?>
                                    <?php if (!empty($item['package_name'])): ?>
                                        <small class="text-muted">(<?= htmlspecialchars($item['package_name']) ?>)</small>
                                    <?php endif; ?>
                                    <br>
                                    <small class="text-muted">Type: <?= htmlspecialchars($item['product_type']) ?></small>
                                </h5>
                                <p class="text-muted mb-2">₹<?= number_format($item['price'], 2) ?></p>
                                <form method="post" action="remove_from_cart.php" style="display: inline;">
                                    <input type="hidden" name="cart_id" value="<?= $item['cart_id'] ?>">
                                    <button type="submit" class="btn btn-sm btn-outline-danger">
                                        <i class="fas fa-trash"></i> Remove
                                    </button>
                                </form>
                            </div>
                            <div class="col-md-3">
                                <form method="post" action="update_cart.php" class="d-flex align-items-center">
                                    <input type="hidden" name="cart_id" value="<?= $item['cart_id'] ?>">
                                    <button type="button" class="btn btn-sm btn-outline-secondary quantity-decrease">-</button>
                                    <input type="number" name="quantity" value="<?= $item['quantity'] ?>" 
                                           min="1" class="form-control mx-2 quantity-input" 
                                           onchange="this.form.submit()">
                                    <button type="button" class="btn btn-sm btn-outline-secondary quantity-increase">+</button>
                                </form>
                            </div>
                            <div class="col-md-3 text-end">
                                <strong>₹<?= number_format($item_total, 2) ?></strong>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>

                <!-- Pad Items Grouped by List -->
               <?php foreach ($pad_items as $type_id => $type): ?>
                    <div class="pad-list-group">
                        <div class="pad-list-header">
                            <h5 class="mb-0"><?= htmlspecialchars($type['type_name']) ?></h5>
                        </div>
                        <div class="p-3">
                            <?php foreach ($type['items'] as $item): 
                                $item_total = $item['price'] * $item['quantity'];
                            ?>
                                <div class="cart-item mb-3">
                                    <div class="row align-items-center">
                                        <div class="col-md-2">
                                            <div class="bg-light d-flex align-items-center justify-content-center" 
                                                 style="width: 80px; height: 80px; border-radius: 8px;">
                                                <i class="fas fa-th-large text-muted"></i>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <h6 class="mb-1">
                                                <?= htmlspecialchars($item['name']) ?>
                                            </h6>
                                            <p class="text-muted mb-2">₹<?= number_format($item['price'], 2) ?></p>
                                            <form method="post" action="remove_from_cart.php" style="display: inline;">
                                                <input type="hidden" name="cart_id" value="<?= $item['cart_id'] ?>">
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-trash"></i> Remove
                                                </button>
                                            </form>
                                        </div>
                                        <div class="col-md-3">
                                            <form method="post" action="update_cart.php" class="d-flex align-items-center">
                                                <input type="hidden" name="cart_id" value="<?= $item['cart_id'] ?>">
                                                <button type="button" class="btn btn-sm btn-outline-secondary quantity-decrease">-</button>
                                                <input type="number" name="quantity" value="<?= $item['quantity'] ?>" 
                                                       min="1" class="form-control mx-2 quantity-input" 
                                                       onchange="this.form.submit()">
                                                <button type="button" class="btn btn-sm btn-outline-secondary quantity-increase">+</button>
                                            </form>
                                        </div>
                                        <div class="col-md-3 text-end">
                                            <strong>₹<?= number_format($item_total, 2) ?></strong>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endforeach; ?>

            </div>
            
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Order Summary</h5>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Subtotal (<?= count($cart_items) ?> items)</span>
                            <span>₹<?= number_format($subtotal, 2) ?></span>
                        </div>
                        <div class="d-flex justify-content-between mb-3">
                            <strong>Total</strong>
                            <strong>₹<?= number_format($subtotal, 2) ?></strong>
                        </div>
                        <a href="checkout.php" class="btn btn-primary w-100">Proceed to Checkout</a>
                        <button id="downloadCartPdf" class="btn btn-success w-100 mt-2">
                            <i class="fas fa-download me-2"></i>Download PDF
                        </button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Quantity controls
document.querySelectorAll('.quantity-increase').forEach(button => {
    button.addEventListener('click', function() {
        const input = this.previousElementSibling;
        input.stepUp();
        input.dispatchEvent(new Event('change'));
    });
});

document.querySelectorAll('.quantity-decrease').forEach(button => {
    button.addEventListener('click', function() {
        const input = this.nextElementSibling;
        if (input.value > 1) {
            input.stepDown();
            input.dispatchEvent(new Event('change'));
        }
    });
});

// PDF Download
document.addEventListener('DOMContentLoaded', function() {
    const downloadBtn = document.getElementById('downloadCartPdf');
    
    if (downloadBtn) {
        downloadBtn.addEventListener('click', function() {
            const { jsPDF } = window.jspdf;
            const doc = new jsPDF();

            // Title
            doc.setFontSize(18);
            doc.text('Savithri Digital - Order Receipt', 14, 22);
            doc.setFontSize(11);
            doc.text(`Date: ${new Date().toLocaleDateString()}`, 14, 30);

            // Table
            const tableColumn = ['#', 'Product', 'Qty', 'Price', 'Total'];
            const tableRows = [];
            let rowIndex = 1;
            let subtotal = 0;

            // Regular items
            document.querySelectorAll('.cart-item:not(.pad-list-group .cart-item)').forEach((item) => {
                const name = item.querySelector('.mb-1').textContent.trim().split('\n')[0].trim();
                const priceText = item.querySelector('.text-muted.mb-2').textContent
                    .replace(/Rs\.?/gi, '')
                    .replace(/₹/g, '')
                    .replace(/[^\d.]/g, '')
                    .trim();
                const price = parseFloat(priceText) || 0;
                const quantity = parseInt(item.querySelector('.quantity-input').value) || 0;
                const total = price * quantity;
                subtotal += total;

                tableRows.push([
                    rowIndex++,
                    name,
                    quantity,
                    '₹' + price.toFixed(2),
                    '₹' + total.toFixed(2)
                ]);
            });

            // Pad items
            document.querySelectorAll('.pad-list-group').forEach((group, groupIndex) => {
                const groupName = group.querySelector('.pad-list-header h5').textContent.trim();
                tableRows.push([{ content: groupName, colSpan: 5, styles: { fontStyle: 'bold', fillColor: [240, 240, 240] } }]);
                
                group.querySelectorAll('.cart-item').forEach((item) => {
                    const name = item.querySelector('h6').textContent.trim().split('\n')[0].trim();
                    const priceText = item.querySelector('.text-muted.mb-2').textContent
                        .replace(/Rs\.?/gi, '')
                        .replace(/₹/g, '')
                        .replace(/[^\d.]/g, '')
                        .trim();
                    const price = parseFloat(priceText) || 0;
                    const quantity = parseInt(item.querySelector('.quantity-input').value) || 0;
                    const total = price * quantity;
                    subtotal += total;

                    tableRows.push([
                        rowIndex++,
                        name,
                        quantity,
                        '₹' + price.toFixed(2),
                        '₹' + total.toFixed(2)
                    ]);
                });
            });

            doc.autoTable({
                head: [tableColumn],
                body: tableRows,
                startY: 40,
                headStyles: {
                    fillColor: [41, 128, 185],
                    textColor: 255,
                    fontStyle: 'bold'
                },
                columnStyles: {
                    0: { cellWidth: 10 },
                    1: { cellWidth: 100 },
                    2: { cellWidth: 20 },
                    3: { cellWidth: 30 },
                    4: { cellWidth: 30 }
                }
            });

            const finalY = doc.lastAutoTable.finalY + 15;
            doc.setFontSize(12);
            doc.setFont(undefined, 'bold');
            doc.text('Subtotal:', 140, finalY);
            doc.text('₹' + subtotal.toFixed(2), 170, finalY);

            doc.save('order-receipt.pdf');
        });
    }
});
</script>

<?php
$conn->close();
if (file_exists($root . 'footer.php')) {
    include $root . 'footer.php';
} else {
    echo '</body></html>';
}
?>